<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('form_field_configs', function (Blueprint $table) {
            $table->id();
            $table->string('form_name');              // e.g., "transfer_form"
            $table->string('field');                  // e.g., "transfer.amount"
            $table->boolean('visible')->default(true);
            $table->boolean('required')->default(false);
            $table->string('label')->nullable();      // Optional override label
            $table->json('extra')->nullable();        // e.g., for placeholder, helper, rules, etc.
            $table->boolean('always_required')->default(false);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('form_field_configs');
    }
};
