<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('ledger_transfers', function (Blueprint $table) {
            $table->integer("recipient_client_id")->foreign()->nullable()->constrained('clients');
            $table->string("recipient_name")->nullable();
            $table->string("recipient_phone")->nullable();
            $table->string("client_sender_name")->nullable();
            $table->string("client_sender_phone")->nullable();
            $table->string("recipient_id_number")->nullable();
            $table->string("client_sender_id_number")->nullable();
            
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('ledger_transfers', function (Blueprint $table) {
            $table->dropColumn("recipient_client_id");
            $table->dropColumn("recipient_name");

            $table->dropColumn("recipient_phone");
            $table->dropColumn("client_sender_name");
            $table->dropColumn("client_sender_phone");
        });
    }
};
