<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('agent_transfer_package_details', function (Blueprint $table) {
            $table->id();
            $table->foreignId('agent_id')->constrained()->onDelete('cascade');
            $table->foreignId('package_id')->constrained('transfer_packages')->onDelete('cascade');

            // Optional override fields:
            $table->decimal('min_amount', 12, 2)->nullable();
            $table->decimal('max_amount', 12, 2)->nullable();
            $table->decimal('send_fee', 12, 2)->nullable();
            $table->decimal('receive_fee', 12, 2)->nullable();
            $table->decimal('another_fee', 12, 2)->nullable();
            $table->enum('send_fee_type', ['fixed', 'percent'])->nullable();
            $table->enum('receive_fee_type', ['fixed', 'percent'])->nullable();

            $table->timestamps();

            $table->unique(['agent_id', 'package_id']); // Each agent can override a package once
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('agent_transfer_package_details');
    }
};
