<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exchange_prices', function (Blueprint $table) {
            $table->id();
            $table->string('from_currency');
            $table->string('to_currency');
            $table->enum('price_source', ['static', 'api']);
            $table->decimal('static_price', 20, 6)->nullable(); // only if static
            $table->string('api_key')->nullable();              // if API
            $table->decimal('difference', 20, 6)->nullable();   // optional for API
            $table->enum('operation', ['*', '/'])->default('*');
            $table->enum('type', ['balance', 'transfer'])->default('balance');
            $table->boolean('active_for_customers')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exchange_prices');
    }
};
