<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('revenue_percents', function (Blueprint $table) {
            $table->id();
            $table->integer("agent_id")->foreign()->nullable()->constrained('agents')->onDelete("cascade");
            $table->float("income")->default(0);
            $table->float("outcome")->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('revenue_percents');
    }
};
