<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('agent_global_credit_limits', function (Blueprint $table) {
            $table->id();
            $table->foreignId('agent_id')->constrained()->onDelete('cascade');
            $table->string('base_currency_code', 3)->default('USD'); // العملة المرجعية (المقوم بها)
            $table->decimal('base_credit_limit', 16, 2)->default(0); // الحد المقوم بالعملة الأساسية
            $table->decimal("approval_credit_limit", 16, 2)->default(0);
            $table->boolean("approval_status")->default(true);
            $table->boolean("transfer_status")->default(true);
            $table->boolean("send_transfer")->default(true);
            $table->boolean("send_approval")->default(true);

            $table->timestamps();

            $table->unique('agent_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('agent_global_credit_limits');
    }
};
