<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('agent_currency_visibility', function (Blueprint $table) {
            $table->id();

            $table->foreignId('agent_id')->constrained()->onDelete('cascade');
            $table->string('currency_code', 10); // Example: USD, TRY, SYP

            $table->boolean('can_send')->default(false);     // Agent can be in "Sender" side
            $table->boolean('can_receive')->default(false);  // Agent can be in "Receiver" side

            $table->timestamps();

            $table->unique(['agent_id', 'currency_code']); // Only one record per agent & currency
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('agent_currency_visibility');
    }
};
