<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_types', function (Blueprint $table) {
            $table->id();
            $table->string("name");
            $table->string("class_name");
            $table->json('config_fields')->nullable();
            $table->timestamps();
        });
        Schema::create('api_configs', function (Blueprint $table) {
            $table->id();
            $table->string("name");
            $table->foreignId('api_type_id')->constrained();
            $table->foreignId('agent_id')->constrained();
            $table->json('config_json');
            $table->string('base_url')->nullable();
            $table->boolean('active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_configs'); // drop child table first
        Schema::dropIfExists('api_types');   // then drop parent table
    }
};
