<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('report_export_logs', function (Blueprint $table) {
            $table->id();
            $table->string('type'); // outgoing or incoming
            $table->date('from_date')->nullable();
            $table->date('to_date')->nullable();
            $table->string('file_path');
            $table->string('status')->default('pending'); // pending, completed, failed
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('report_export_logs');
    }
};
