<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('ledger_transfers', function (Blueprint $table) {
            $table->index('status');
            $table->index('type');
            $table->index('date');
            $table->index('created_at');
            $table->index(['sender_id', 'receiver_id']);
            $table->index('external_agent_id');
            $table->index('secret');
            $table->index(['sender_id', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('ledger_transfers', function (Blueprint $table) {
            //$table->dropForeign(['sender_id']); // or the correct column
            //  $table->dropIndex("ledger_transfers_sender_id_status_index");
            // $table->dropIndex(['status']);
            // $table->dropIndex(['type']);
            // $table->dropIndex(['date']);
            // $table->dropIndex(['created_at']);
            // $table->dropIndex(['sender_id', 'receiver_id']);
            // $table->dropIndex(['external_agent_id']);
            // $table->dropIndex(['secret']);
            // $table->dropIndex(['sender_id', 'status']);
        });
    }
};
