<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Abivia\Ledger\Http\Controllers\LedgerAccountController;
use Abivia\Ledger\Messages\Account;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\Models\Agent;
use App\Models\CustomLedgerAccount;
use App\Services\Ledger\AgentLedgerService;

class AgentSeeder extends Seeder
{
    protected array $agents = [

        'Istanbul',
        'Aleppo',
        'Kayseri',
        'Ankara',
        'Homs',
        'Damascus',
    ];

    public function run(): void
    {
        $agents = [

            ['code' => 'IST', 'name' => 'Istanbul'],
            ['code' => 'ALE', 'name' => 'Aleppo'],
            ['code' => 'KAY', 'name' => 'Kayseri'],
            ['code' => 'ANK', 'name' => 'Ankara'],
            ['code' => 'HOM', 'name' => 'Homs'],
            ['code' => 'DAM', 'name' => 'Damascus'],
        ];

        foreach ($agents as $data) {
            $agent = Agent::updateOrCreate(
                ['code' => $data['code']],
                [
                    'name' => $data['name'],
                    'username' => strtolower($data['code']),
                    'password' => bcrypt('secret'), // default password
                    'is_active' => true,
                    'credit_limit' => 0,
                ]
            );

            $agents = [
                ['code' => '1300', 'name' => 'حوالات  غير مستلمة'],
                ['code' => '5200', 'name' => 'عمولات  غير محققة'],

            ];



            $this->command->info("Agent {$data['name']} seeded and ledger accounts created.");
        }
        foreach ($agents as $data) {
            $agent = new Agent();
            $agent->name = $data['name'];
            $agent->code = $data['code'];
            $agent->type = "account";
            $agent->save();
            $account = CustomLedgerAccount::where("code", $data['code'])->first();
            $extra = $account->extra;
            $extra['agent_id'] = $agent->id;
            $account->agent_id = $agent->id;
            $account->extra = $extra;
            $account->save();
        }
        // $service = new AgentLedgerService();
        //$service->createLedgerAccountsForAllAgents();
    }
}
