<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;

class FormFieldConfigSeeder extends Seeder
{
  /**
   * Run the database seeds.
   */
  public function run(): void
  {
    $formName = 'booking_form';

    $fields = [
      ['field' => 'transfer.sender_id',        'label' => 'المرسل', 'visible' => true, 'required' => true, 'tab_index' => 1],
      ['field' => 'transfer.currency',         'label' => 'العملة', 'visible' => true, 'required' => true, 'tab_index' => 2],
      ['field' => 'transfer.amount',           'label' => 'المبلغ المرسل', 'visible' => true, 'required' => true, 'tab_index' => 3],
      ['field' => 'transfer.send_fee',         'label' => 'أجور التحويل', 'visible' => true, 'required' => true, 'tab_index' => 4],
      ['field' => 'transfer.fee_type',         'label' => 'نوع الأجور', 'visible' => true, 'required' => false, 'tab_index' => 5],
      ['field' => 'transfer.note',             'label' => 'ملاحظات المرسل', 'visible' => true, 'required' => false, 'tab_index' => 6],

      ['field' => 'transfer.receiver_id',      'label' => 'المستلم', 'visible' => true, 'required' => true, 'tab_index' => 7],
      ['field' => 'transfer.delivery_currency', 'label' => 'عملة الاستلام', 'visible' => true, 'required' => true, 'tab_index' => 8],
      ['field' => 'transfer.delivery_amount',  'label' => 'المبلغ المستلم', 'visible' => true, 'required' => true, 'tab_index' => 9],
      ['field' => 'transfer.receiver_fee',     'label' => 'أجور المستلم', 'visible' => true, 'required' => true, 'tab_index' => 10],
      ['field' => 'transfer.receiver_fee_type', 'label' => 'نوع أجور المستلم', 'visible' => true, 'required' => false, 'tab_index' => 11],
      ['field' => 'transfer.receiver_note',    'label' => 'ملاحظات المستلم', 'visible' => true, 'required' => false, 'tab_index' => 12],
      ['field' => 'transfer.date',             'label' => 'تاريخ التحويل', 'visible' => true, 'required' => true, 'tab_index' => 13],
      ['field' => 'transfer.exchange_rate',    'label' => 'سعر الصرف', 'visible' => true, 'required' => false, 'tab_index' => 14],
      ['field' => 'transfer.rate_factor',      'label' => 'عامل الصرف', 'visible' => true, 'required' => false, 'tab_index' => 15],
      ['field' => 'recipient.name',           'label' => 'المستفيد', 'visible' => true, 'required' => false, 'tab_index' => 15],
      ['field' => 'transfer.attachments',      'label' => 'المرفقات', 'visible' => true, 'required' => false, 'tab_index' => 16],
    ];

    foreach ($fields as $field) {
      DB::table('form_field_configs')->updateOrInsert(
        ['form_name' => $formName, 'field' => $field['field']],
        [
          'label' => $field['label'],
          'visible' => $field['visible'],
          'required' => $field['required'],
          'extra' => null,
          'updated_at' => now(),
          'created_at' => now(),
        ]
      );
    }
    $now = now();
    $formName = 'transfer_form';
    $fields = [
      ['field' => 'recipient.sender_identity_number', 'label' => __('transfers.sender_national_id'),  'required' => true, 'tab_index' => 1],
      ['field' => 'transfer.sender_id',               'label' => __('transfers.sender_agent'),        'required' => true, 'tab_index' => 2],
      ['field' => 'transfer.recipient_name',          'label' => __('transfers.recipient_name'),      'required' => true, 'tab_index' => 3],
      ['field' => 'transfer.recipient_phone',         'label' => __('transfers.recipient_phone'),     'required' => true, 'tab_index' => 4],
      ['field' => 'transfer.receiver_id',             'label' => __('transfers.receiver_agent'),      'required' => true, 'tab_index' => 5],
      ['field' => 'transfer.currency',                'label' => __('transfers.sent_currency'),       'required' => true, 'tab_index' => 6],
      ['field' => 'transfer.amount',                  'label' => __('transfers.amount_to_send'),      'required' => true, 'tab_index' => 7],
      ['field' => 'transfer.delivery_currency',       'label' => __('transfers.delivery_currency'),   'required' => true, 'tab_index' => 8],
      ['field' => 'transfer.delivery_amount',         'label' => __('transfers.total_to_receive'),    'required' => true, 'tab_index' => 9],
      ['field' => 'transfer.send_fee',                'label' => __('transfers.transfer_fee'),        'required' => false, 'tab_index' => 10],
      ['field' => 'transfer.receiver_fee',            'label' => __('transfers.delivery_fee'),        'required' => false, 'tab_index' => 11],
      ['field' => 'transfer.fee_type',                'label' => __('transfers.fee_type'),            'required' => false, 'tab_index' => 12],
      ['field' => 'transfer.exchange_rate',           'label' => __('transfers.exchange_rate'),       'required' => false, 'tab_index' => 13],
      ['field' => 'transfer.notes',                   'label' => __('transfers.notes'),               'required' => false, 'tab_index' => 14],
      ['field' => 'transfer.reason_id',               'label' => __('transfers.transfer_reason'),     'required' => false, 'tab_index' => 15],
      ['field' => 'attatchments',                     'label' => __('transfers.attachment'),          'required' => false, 'tab_index' => 16],
      ['field' => 'attachment_type',                  'label' => __('transfers.attachment_type'),     'required' => false, 'tab_index' => 17],
    ];

    foreach ($fields as $field) {
      DB::table('form_field_configs')->insert([
        'form_name'       => $formName,
        'field'           => $field['field'],
        'label'           => $field['label'],
        'visible'         => 1,
        'required'        => $field['required'] ? 1 : 0,
        'always_required' => $field['required'] ? 1 : 0,
        'extra'           => null,
        'created_at'      => $now,
        'updated_at'      => $now,
      ]);
    }
    App::setLocale('ar'); // Ensure Arabic is used for translations

    $now = now();
    $formName = 'client_form';

    $fields = [
      ['field' => 'client.type',          'label' => __('client.type'),              'required' => true, 'tab_index' => 1],
      ['field' => 'client.name.ar',       'label' => __('client.name_ar'),           'required' => true, 'tab_index' => 2],
      ['field' => 'client.name.en',       'label' => __('client.name_en'),           'required' => false, 'tab_index' => 3],
      ['field' => 'client.birth_place',   'label' => __('client.birth_place'),       'required' => false, 'tab_index' => 4],
      ['field' => 'client.birth_date',    'label' => __('client.birth_date'),        'required' => false, 'tab_index' => 5],
      ['field' => 'client.gender',        'label' => __('client.gender'),            'required' => false, 'tab_index' => 6],
      ['field' => 'client.mother_name',   'label' => __('client.mother_name'),       'required' => false, 'tab_index' => 7],
      ['field' => 'client.identity_type', 'label' => __('client.identity_type'),     'required' => true,  'tab_index' => 8],
      ['field' => 'client.identity_number', 'label' => __('client.identity_number'),  'required' => true,  'tab_index' => 9],
      ['field' => 'client.nationality',   'label' => __('client.nationality'),       'required' => false, 'tab_index' => 10],
      ['field' => 'client.phone',         'label' => __('client.phone'),             'required' => false, 'tab_index' => 11],
      ['field' => 'client.mobile',        'label' => __('client.mobile'),            'required' => false, 'tab_index' => 12],
      ['field' => 'client.job',           'label' => __('client.job'),               'required' => false, 'tab_index' => 13],
      ['field' => 'address.country',      'label' => __('client.address_country'),   'required' => false, 'tab_index' => 14],
      ['field' => 'address.city',         'label' => __('client.address_city'),      'required' => false, 'tab_index' => 15],
      ['field' => 'address.state',        'label' => __('client.address_state'),     'required' => false, 'tab_index' => 16],
      ['field' => 'address.neighborhood', 'label' => __('client.address_neighborhood'), 'required' => false, 'tab_index' => 17],
      ['field' => 'address.district',     'label' => __('client.address_district'),  'required' => false, 'tab_index' => 18],
      ['field' => 'client.details',       'label' => __('client.details'),           'required' => false, 'tab_index' => 19],
      ['field' => 'attachments',          'label' => __('client.attachments'),       'required' => false, 'tab_index' => 20],
    ];

    foreach ($fields as $field) {
      DB::table('form_field_configs')->insert([
        'form_name'       => $formName,
        'field'           => $field['field'],
        'label'           => $field['label'], // Translated label
        'visible'         => 1,
        'required'        => $field['required'] ? 1 : 0,
        'always_required' => $field['required'] ? 1 : 0,
        'extra'           => null,
        'created_at'      => $now,
        'updated_at'      => $now,
      ]);
    }
  }
}
