/**
 *  Logistics Dashboard
 */

(function () {
  let borderColor, labelColor, headingColor, legendColor;
  let BudgetChart;
  let CategoryChart;
  const isDarkStyle = $('html').hasClass('dark-style') || $('html').hasClass('semi-dark-style');
  if (isDarkStyle) {
    borderColor = config.colors_dark.borderColor;
    labelColor = config.colors_dark.textMuted;
    headingColor = config.colors_dark.headingColor;
    legendColor = config.colors_dark.bodyColor;
  } else {
    borderColor = config.colors.borderColor;
    labelColor = config.colors.textMuted;
    headingColor = config.colors.headingColor;
    legendColor = config.colors.bodyColor;
  }

  // Chart Colors
  const chartColors = {
    donut: {
      series1: config.colors.success,
      series2: config.colors.primary,
      series3: config.colors.warning,
      series4: config.colors.danger,
      series5: '#7EDDA9',
      series6: '#A9E9C5'
    },
    line: {
      series1: config.colors.warning,
      series2: config.colors.primary,
      series3: '#7367f029'
    }
  };

  window.addEventListener('BudgetChartDataUpdated', function (event) {
    var data = event.detail[0].data;
    var series = data['series'];
    var categories = data['categories'];
    InitBudgetChart(series, categories);
  });
  window.addEventListener('initCategoryChart', function (event) {
    var series = event.detail[0].series;
    var labels = event.detail[0].labels;
    initCategoryChart(labels, series);
  });

  // Shipment statistics Chart
  // --------------------------------------------------------------------

  function InitBudgetChart(series, categories) {
    console.log('Budget Chart Data:', series, categories);

    const allValues = series.flatMap(s => s.data);
    const maxValue = Math.max(...allValues);
    const yAxisMax = Math.ceil((maxValue * 1.2) / 10000) * 10000;

    const shipmentEl = document.querySelector('#BudgetStatisticsChart');
    if (!shipmentEl) return;

    const shipmentConfig = {
      series: series,
      chart: {
        height: 320,
        type: 'line',
        stacked: false,
        parentHeightOffset: 0,
        toolbar: { show: false },
        zoom: { enabled: false }
      },
      markers: {
        size: 5,
        colors: [config.colors.white],
        strokeColors: chartColors.line.series2,
        hover: { size: 6 },
        borderRadius: 4
      },
      stroke: {
        curve: 'smooth',
        width: [0, 3],
        lineCap: 'round'
      },
      legend: {
        show: true,
        position: 'bottom',
        markers: {
          width: 8,
          height: 8,
          offsetX: -3
        },
        height: 40,
        itemMargin: {
          horizontal: 10,
          vertical: 0
        },
        fontSize: '15px',
        fontFamily: 'Public Sans',
        fontWeight: 400,
        labels: {
          colors: headingColor,
          useSeriesColors: false
        },
        offsetY: 10
      },
      grid: {
        strokeDashArray: 8,
        borderColor
      },
      colors: [chartColors.line.series1, chartColors.line.series2],
      fill: {
        opacity: [1, 1]
      },
      plotOptions: {
        bar: {
          columnWidth: '30%',
          startingShape: 'rounded',
          endingShape: 'rounded',
          borderRadius: 4
        }
      },
      dataLabels: { enabled: false },
      xaxis: {
        tickAmount: 10,
        categories: categories,
        labels: {
          style: {
            colors: labelColor,
            fontSize: '13px',
            fontWeight: 400
          }
        },
        axisBorder: { show: false },
        axisTicks: { show: false }
      },
      yaxis: {
        min: 0,
        max: yAxisMax,
        tickAmount: 5,
        labels: {
          formatter: function (val) {
            return val.toLocaleString() + ' ₺';
          }
        }
      },
      responsive: [
        {
          breakpoint: 1400,
          options: {
            chart: { height: 320 },
            xaxis: { labels: { style: { fontSize: '10px' } } },
            legend: {
              itemMargin: {
                vertical: 0,
                horizontal: 10
              },
              fontSize: '13px',
              offsetY: 12
            }
          }
        },
        {
          breakpoint: 1025,
          options: {
            chart: { height: 415 },
            plotOptions: { bar: { columnWidth: '50%' } }
          }
        },
        {
          breakpoint: 982,
          options: { plotOptions: { bar: { columnWidth: '30%' } } }
        },
        {
          breakpoint: 480,
          options: {
            chart: { height: 250 },
            legend: { offsetY: 7 }
          }
        }
      ]
    };

    if (!BudgetChart) {
      BudgetChart = new ApexCharts(shipmentEl, shipmentConfig);
      BudgetChart.render();
    } else {
      BudgetChart.updateOptions(shipmentConfig);
    }
  }

  function initCategoryChart(labels, series) {
    // Reasons for delivery exceptions Chart
    // --------------------------------------------------------------------
    const deliveryExceptionsChartE1 = document.querySelector('#deliveryExceptionsChart'),
      deliveryExceptionsChartConfig = {
        chart: {
          height: 420,
          parentHeightOffset: 0,
          type: 'donut'
        },
        labels: labels,
        series: series,
        colors: [
          chartColors.donut.series1,
          chartColors.donut.series2,
          chartColors.donut.series3,
          chartColors.donut.series4
        ],
        stroke: {
          width: 0
        },
        dataLabels: {
          enabled: false,
          formatter: function (val, opt) {
            return parseInt(val);
          }
        },
        legend: {
          show: true,
          position: 'bottom',
          offsetY: 10,
          markers: {
            width: 8,
            height: 8,
            offsetX: -3
          },
          itemMargin: {
            horizontal: 15,
            vertical: 5
          },
          fontSize: '13px',
          fontFamily: 'Public Sans',
          fontWeight: 400,
          labels: {
            colors: headingColor,
            useSeriesColors: false
          }
        },
        tooltip: {
          theme: false
        },
        grid: {
          padding: {
            top: 15
          }
        },
        plotOptions: {
          pie: {
            donut: {
              size: '77%',
              labels: {
                show: true,
                value: {
                  fontSize: '24px',
                  fontFamily: 'Public Sans',
                  color: headingColor,
                  fontWeight: 500,
                  offsetY: -20,
                  formatter: function (val) {
                    return parseInt(val);
                  }
                },
                name: {
                  offsetY: 30,
                  fontFamily: 'Public Sans'
                },
                total: {
                  show: true,
                  fontSize: '15px',
                  fontFamily: 'Public Sans',
                  color: legendColor,

                  formatter: function (w) {
                    return parseInt(w.globals.seriesTotals.reduce((a, b) => a + b, 0));
                  }
                }
              }
            }
          }
        },
        responsive: [
          {
            breakpoint: 420,
            options: {
              chart: {
                height: 360
              }
            }
          }
        ]
      };
    if (!CategoryChart) {
      CategoryChart = new ApexCharts(deliveryExceptionsChartE1, deliveryExceptionsChartConfig);
      CategoryChart.render();
    } else {
      CategoryChart.updateOptions(deliveryExceptionsChartConfig);
    }
  }
  window.addEventListener('filtersApplied', function (event) {
    const data = event.detail[0];
    console.log(data);
    let table = window.LaravelDataTables['budget-table'];
    if (table) {
      // Stringify the filters object before storing
      window.filters = JSON.parse(JSON.stringify(data.filters));

      // Force a full reload
      table.ajax.reload();
    }
    table = window.LaravelDataTables['charity-table'];
    if (table) {
      // Stringify the filters object before storing
      window.filters = JSON.parse(JSON.stringify(data.filters));

      // Force a full reload
      table.ajax.reload();
    }
  });
})();
