/**
 * Page Expense List
 */

'use strict';

// Datatable (jquery)
(function () {
  // Variable declaration for table
  var dt_expense_table = $('.datatables-expenses'),
    expenseView = baseUrl + 'app/expense/view/',
    offCanvasForm = $('#addExpenseModal');
  let currentChart = null;
  let expenseChart = null;
  let monthlyExpenseChart = null;
  // ajax setup
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  let borderColor, labelColor, headingColor, legendColor;
  const isDarkStyle = $('html').hasClass('dark-style') || $('html').hasClass('semi-dark-style');
  if (isDarkStyle) {
    borderColor = config.colors_dark.borderColor;
    labelColor = config.colors_dark.textMuted;
    headingColor = config.colors_dark.headingColor;
    legendColor = config.colors_dark.bodyColor;
  } else {
    borderColor = config.colors.borderColor;
    labelColor = config.colors.textMuted;
    headingColor = config.colors.headingColor;
    legendColor = config.colors.bodyColor;
  }

  // Chart Colors
  const chartColors = {
    donut: {
      series1: config.colors.success,
      series2: config.colors.primary,
      series3: config.colors.warning,
      series4: config.colors.danger,
      series5: '#7EDDA9',
      series6: '#A9E9C5'
    },
    line: {
      series1: config.colors.warning,
      series2: config.colors.primary,
      series3: '#7367f029'
    }
  };

  window.addEventListener('ExpenseChartDataUpdated', function (event) {
    console.log(event);
    var data = event.detail[0].data;
    var series = data['amounts'];
    var categories = data['categories'];
    console.log(series, categories);
    InitExpenseChart(series, categories);
  });
  function InitExpenseChart(series, categories) {
    const chartEl = document.querySelector('#BudgetStatisticsChart');
    if (!chartEl) return;

    const allValues = series.flatMap(s => s.data);
    const maxValue = Math.max(...allValues);
    const yAxisMax = Math.ceil((maxValue * 1.2) / 10000) * 10000;

    const shipmentConfig = {
      series: series,
      chart: {
        height: 320,
        type: 'bar',
        stacked: false,
        parentHeightOffset: 0,
        toolbar: { show: false },
        zoom: { enabled: false }
      },
      markers: {
        size: 5,
        colors: [config.colors.white],
        strokeColors: chartColors.line.series2,
        hover: { size: 6 },
        borderRadius: 4
      },
      stroke: {
        curve: 'smooth',
        width: [0, 3],
        lineCap: 'round'
      },
      legend: {
        show: true,
        position: 'bottom',
        markers: {
          width: 8,
          height: 8,
          offsetX: -3
        },
        height: 40,
        itemMargin: {
          horizontal: 10,
          vertical: 0
        },
        fontSize: '15px',
        fontFamily: 'Public Sans',
        fontWeight: 400,
        labels: {
          colors: headingColor,
          useSeriesColors: false
        },
        offsetY: 10
      },
      grid: {
        strokeDashArray: 8,
        borderColor
      },
      colors: [chartColors.line.series1, chartColors.line.series2],
      fill: {
        opacity: [1, 1]
      },
      plotOptions: {
        bar: {
          columnWidth: '30%',
          startingShape: 'rounded',
          endingShape: 'rounded',
          borderRadius: 4
        }
      },
      dataLabels: { enabled: false },
      xaxis: {
        tickAmount: 10,
        categories: categories,
        labels: {
          style: {
            colors: labelColor,
            fontSize: '13px',
            fontWeight: 400
          }
        },
        axisBorder: { show: false },
        axisTicks: { show: false }
      },
      yaxis: {
        min: 0,
        max: yAxisMax,
        tickAmount: 5,
        labels: {
          formatter: function (val) {
            return val.toLocaleString() + ' ₺';
          }
        }
      },
      responsive: [
        {
          breakpoint: 1400,
          options: {
            chart: { height: 320 },
            xaxis: { labels: { style: { fontSize: '10px' } } },
            legend: {
              itemMargin: {
                vertical: 0,
                horizontal: 10
              },
              fontSize: '13px',
              offsetY: 12
            }
          }
        },
        {
          breakpoint: 1025,
          options: {
            chart: { height: 415 },
            plotOptions: { bar: { columnWidth: '50%' } }
          }
        },
        {
          breakpoint: 982,
          options: { plotOptions: { bar: { columnWidth: '30%' } } }
        },
        {
          breakpoint: 480,
          options: {
            chart: { height: 250 },
            legend: { offsetY: 7 }
          }
        }
      ]
    };
    if (!currentChart) {
      currentChart = new ApexCharts(chartEl, shipmentConfig);
      currentChart.render();
    } else {
      currentChart.updateOptions(shipmentConfig);
    }
  }
  window.addEventListener('MonthlyExpenseChartDataUpdated', function (event) {
    const data = event.detail[0].data;
    const text = event.detail[0].text;
    InitMonthlyExpenseChart(data.amounts, data.categories, text);
  });
  function InitMonthlyExpenseChart(series, categories, text = 'Expense') {
    const chartEl = document.querySelector('#totalExpensesChart');
    const chartConfig = {
      series: [
        {
          name: text,
          data: series
        }
      ],
      chart: {
        height: 320,
        type: 'line',
        toolbar: { show: false }
      },
      stroke: {
        curve: 'smooth',
        width: 3
      },
      xaxis: {
        categories: categories,
        labels: {
          style: {
            colors: '#6E6B7B',
            fontSize: '13px'
          }
        }
      },
      yaxis: {
        labels: {
          formatter: val => val.toLocaleString() + ' ₺'
        }
      },
      colors: ['#FF6F61'],
      markers: {
        size: 5
      },
      tooltip: {
        y: {
          formatter: val => val.toLocaleString() + ' ₺'
        }
      }
    };

    if (!monthlyExpenseChart) monthlyExpenseChart = new ApexCharts(chartEl, chartConfig).render();
    else {
      monthlyExpenseChart.updateOptions(chartConfig);
    }
  }

  function initExpenseComparisonChart(series, categories) {
    const options = {
      chart: {
        type: 'line',
        height: 400,
        animations: {
          enabled: true
        }
      },
      series: series,
      xaxis: {
        categories: categories,
        labels: {
          rotate: -45,
          rotateAlways: true
        }
      },
      stroke: {
        curve: 'smooth'
      },
      markers: {
        size: 4
      },
      tooltip: {
        shared: true,
        intersect: false
      },
      legend: {
        position: 'top'
      }
    };

    if (expenseChart !== null) {
      expenseChart.updateOptions(options);
    } else {
      expenseChart = new ApexCharts(document.querySelector('#expense-comparison-chart'), options);
      expenseChart.render();
    }
  }
  Livewire.on('expenseComparisonData', data => {
    if (Array.isArray(data) && data.length > 0) {
      data = data[0]; // unwrap the object inside the array
    }
    console.log('Received chart data:', data);
    initExpenseComparisonChart(data.series, data.categories);
  });
  window.addEventListener('filtersApplied', function (event) {
    const data = event.detail[0];

    const table = window.LaravelDataTables['income-table'];
    if (table) {
      // Stringify the filters object before storing
      window.filters = JSON.parse(JSON.stringify(data.filters));

      // Force a full reload
      table.ajax.reload();
    }
  });
})();
