/**
 * App Invoice List (jquery)
 */

'use strict';

(function () {
  // Variable declaration for table
  var dt_payment_table = $('.payment-list-table');
  let paymentTrendsChart = null;
  let paymentMethodsChart = null;
  let borderColor, labelColor, headingColor, legendColor;
  const isDarkStyle = $('html').hasClass('dark-style') || $('html').hasClass('semi-dark-style');
  if (isDarkStyle) {
    borderColor = config.colors_dark.borderColor;
    labelColor = config.colors_dark.textMuted;
    headingColor = config.colors_dark.headingColor;
    legendColor = config.colors_dark.bodyColor;
  } else {
    borderColor = config.colors.borderColor;
    labelColor = config.colors.textMuted;
    headingColor = config.colors.headingColor;
    legendColor = config.colors.bodyColor;
  }

  // Chart Colors
  const chartColors = {
    donut: {
      series1: config.colors.success,
      series2: config.colors.primary,
      series3: config.colors.warning,
      series4: config.colors.danger,
      series5: '#7EDDA9',
      series6: '#A9E9C5'
    },
    line: {
      series1: config.colors.warning,
      series2: config.colors.primary,
      series3: '#7367f029'
    }
  };
  // Invoice datatable
  window.addEventListener('InitializePaymentTable', function (event) {
    setTimeout(() => {
      if (!$.fn.DataTable.isDataTable('.payment-list-table')) {
        $('.payment-list-table').DataTable({
          ajax: {
            url: '/Payment/index_data'
          }, // JSON file to add data
          columns: [
            // columns according to JSON
            { data: 'id' },
            { data: 'id' },
            { data: 'id' },

            { data: 'invoice_number' },

            { data: 'bbno' },
            { data: 'tenant_name' },

            { data: 'amount' },
            { data: 'created_at' },

            { data: 'reference' },
            { data: 'action' }
          ],
          columnDefs: [
            {
              // For Responsive
              className: 'control',
              responsivePriority: 2,
              searchable: false,
              targets: 0,
              render: function (data, type, full, meta) {
                return '';
              }
            },
            {
              // For Checkboxes
              targets: 1,
              orderable: false,
              checkboxes: {
                selectAllRender: '<input type="checkbox" class="form-check-input">'
              },
              render: function () {
                return '<input type="checkbox" class="dt-checkboxes form-check-input" >';
              },
              searchable: false
            },
            {
              // Invoice ID
              targets: 2,
              render: function (data, type, full, meta) {
                return full['id'];
              }
            },
            {
              // Invoice ID
              targets: 3,
              render: function (data, type, full, meta) {
                var id = full['invoice_id'];
                var $invoice_id = full['invoice_number'];
                // Creates full output for row
                var $row_output = '<a href="' + baseUrl + 'Invoice/' + id + '">#' + $invoice_id + '</a>';
                return $row_output;
              }
            },
            {
              // Invoice status
              targets: 4,
              render: function (data, type, full, meta) {
                return full['bbno'];
                var $invoice_status = full['bbno'],
                  $due_date = full['due_date'],
                  $balance = full['remaining_amount'];
                var roleBadgeObj = {
                  pending:
                    '<span class="badge badge-center rounded-pill bg-label-secondary w-px-30 h-px-30 d-flex align-items-center justify-content-center"><i class="ti ti-circle-check ti-xs"></i></span>',
                  draft:
                    '<span class="badge badge-center rounded-pill bg-label-primary w-px-30 h-px-30 d-flex align-items-center justify-content-center"><i class="ti ti-device-floppy ti-xs"></i></span>',
                  overdue:
                    '<span class="badge badge-center rounded-pill bg-label-danger w-px-30 h-px-30 d-flex align-items-center justify-content-center"><i class="ti ti-info-circle ti-xs"></i></span>',
                  partial:
                    '<span class="badge badge-center rounded-pill bg-label-success w-px-30 h-px-30 d-flex align-items-center justify-content-center"><i class="ti ti-circle-half-2 ti-xs"></i></span>',
                  paid: '<span class="badge badge-center rounded-pill bg-label-warning w-px-30 h-px-30 d-flex align-items-center justify-content-center"><i class="ti ti-chart-pie ti-xs"></i></span>',
                  cancelled:
                    '<span class="badge badge-center rounded-pill bg-label-danger w-px-30 h-px-30 d-flex align-items-center justify-content-center"><i class="ti ti-close ti-xs"></i></span>',
                  Downloaded:
                    '<span class="badge badge-center rounded-pill bg-label-info w-px-30 h-px-30 d-flex align-items-center justify-content-center"><i class="ti ti-arrow-down-circle ti-xs"></i></span>'
                };
                return (
                  "<span class='d-inline-block' data-bs-toggle='tooltip' data-bs-html='true' title='<span>" +
                  $invoice_status +
                  '<br> <span class="fw-medium">Balance:</span> ' +
                  $balance +
                  '<br> <span class="fw-medium">Due Date:</span> ' +
                  $due_date +
                  "</span>'>" +
                  roleBadgeObj[$invoice_status] +
                  '</span>'
                );
              }
            },
            {
              // Client name and Service
              targets: 5,
              responsivePriority: 5,
              render: function (data, type, full, meta) {
                var $name = full['tenant_name'],
                  $service = full['service'],
                  $image = full['avatar_image'],
                  $rand_num = Math.floor(Math.random() * 11) + 1,
                  $user_img = $rand_num + '.png';
                if ($image === true) {
                  // For Avatar image
                  var $output =
                    '<img src="' + assetsPath + 'img/avatars/' + $user_img + '" alt="Avatar" class="rounded-circle">';
                } else {
                  // For Avatar badge
                  var stateNum = Math.floor(Math.random() * 6),
                    states = ['success', 'danger', 'warning', 'info', 'primary', 'secondary'],
                    $state = states[stateNum],
                    $name = full['tenant_name'],
                    $initials = $name.match(/\b\w/g) || [];
                  $initials = (($initials.shift() || '') + ($initials.pop() || '')).toUpperCase();
                  $output =
                    '<span class="avatar-initial rounded-circle bg-label-' + $state + '">' + $initials + '</span>';
                }
                // Creates full output for row
                var $row_output =
                  '<div class="d-flex justify-content-start align-items-center">' +
                  '<div class="avatar-wrapper">' +
                  '<div class="avatar avatar-sm me-3">' +
                  $output +
                  '</div>' +
                  '</div>' +
                  '<div class="d-flex flex-column">' +
                  '<a href="' +
                  baseUrl +
                  'pages/profile-user" class="text-heading text-truncate"><span class="fw-medium">' +
                  $name +
                  '</span></a>' +
                  '</div>' +
                  '</div>';
                return $row_output;
              }
            },
            {
              // Total Invoice Amount
              targets: 6,
              render: function (data, type, full, meta) {
                var $total = full['amount'];
                return '<span class="d-none">' + $total + '</span>' + $total;
              }
            },
            {
              // Due Date
              targets: 7,
              render: function (data, type, full, meta) {
                var $due_date = new Date(full['created_at']);
                // Creates full output for row
                var $row_output =
                  '<span class="d-none">' +
                  moment($due_date).format('YYYYMMDD') +
                  '</span>' +
                  moment($due_date).format('DD MMM YYYY');
                $due_date;
                return $row_output;
              }
            },
            {
              // Client Balance/Status
              targets: 8,
              orderable: false,
              render: function (data, type, full, meta) {
                return full['reference'];
              }
            },

            {
              // Actions
              targets: -1,
              title: 'Actions',
              searchable: false,
              orderable: false,
              render: function (data, type, full, meta) {
                return (
                  '<div class="d-flex align-items-center">' +
                  '<a href="javascript:;" data-bs-toggle="tooltip" class="btn btn-icon btn-text-secondary waves-effect waves-light rounded-pill" data-bs-placement="top" title="Delete"><i class="ti ti-trash mx-2 ti-md"></i></a>' +
                  '<a href="' +
                  baseUrl +
                  'app/invoice/preview" data-bs-toggle="tooltip" class="btn btn-icon btn-text-secondary waves-effect waves-light rounded-pill" data-bs-placement="top" title="Preview Invoice"><i class="ti ti-eye mx-2 ti-md"></i></a>' +
                  '<div class="dropdown">' +
                  '<a href="javascript:;" class="btn dropdown-toggle hide-arrow btn btn-icon btn-text-secondary waves-effect waves-light rounded-pill p-0" data-bs-toggle="dropdown"><i class="ti ti-dots-vertical ti-md"></i></a>' +
                  '<div class="dropdown-menu dropdown-menu-end">' +
                  '<a href="javascript:;" class="dropdown-item">Download</a>' +
                  '<a href="' +
                  baseUrl +
                  'app/invoice/edit" class="dropdown-item">Edit</a>' +
                  '<a href="javascript:;" class="dropdown-item">Duplicate</a>' +
                  '</div>' +
                  '</div>'
                );
              }
            }
          ],
          order: [[2, 'desc']],
          dom:
            '<"row mx-1"' +
            '<"col-12 col-md-6 d-flex align-items-center justify-content-center justify-content-md-start gap-2"l<"dt-action-buttons text-xl-end text-lg-start text-md-end text-start"B>>' +
            '<"col-12 col-md-6 d-flex align-items-center justify-content-end flex-column flex-md-row pe-5 gap-md-4 mt-n6 mt-md-0"f<"payment_status mb-6 mb-md-0">>' +
            '>t' +
            '<"row mx-1"' +
            '<"col-sm-12 col-md-6"i>' +
            '<"col-sm-12 col-md-6"p>' +
            '>',
          language: {
            sLengthMenu: 'Show _MENU_',
            search: '',
            searchPlaceholder: 'Search Invoice',
            paginate: {
              next: '<i class="ti ti-chevron-right ti-sm"></i>',
              previous: '<i class="ti ti-chevron-left ti-sm"></i>'
            }
          },
          // Buttons with Dropdown
          buttons: [
            {
              text: '<i class="ti ti-plus ti-xs me-md-2"></i><span class="d-md-inline-block d-none"></span>',
              className: 'btn btn-primary waves-effect waves-light',
              action: function (e, dt, button, config) {
                window.location = baseUrl + 'app/invoice/add';
              }
            }
          ],
          // For responsive popup
          responsive: {
            details: {
              display: $.fn.dataTable.Responsive.display.modal({
                header: function (row) {
                  var data = row.data();
                  return 'Details of ' + data['full_name'];
                }
              }),
              type: 'column',
              renderer: function (api, rowIdx, columns) {
                var data = $.map(columns, function (col, i) {
                  return col.title !== '' // ? Do not show row in modal popup if title is blank (for check box)
                    ? '<tr data-dt-row="' +
                        col.rowIndex +
                        '" data-dt-column="' +
                        col.columnIndex +
                        '">' +
                        '<td>' +
                        col.title +
                        ':' +
                        '</td> ' +
                        '<td>' +
                        col.data +
                        '</td>' +
                        '</tr>'
                    : '';
                }).join('');

                return data ? $('<table class="table"/><tbody />').append(data) : false;
              }
            }
          },
          initComplete: function () {
            // Adding role filter once table initialized
            this.api()
              .columns(8)
              .every(function () {
                var column = this;
                var select = $(
                  '<select id="UserRole" class="form-select"><option value=""> Invoice Status </option></select>'
                )
                  .appendTo('.payment_status')
                  .on('change', function () {
                    var val = $.fn.dataTable.util.escapeRegex($(this).val());
                    column.search(val ? '^' + val + '$' : '', true, false).draw();
                  });

                column
                  .data()
                  .unique()
                  .sort()
                  .each(function (d, j) {
                    select.append('<option value="' + d + '" class="text-capitalize">' + d + '</option>');
                  });
              });
          }
        });
      } else {
        $.fn.dataTable.tables({ visible: true, api: true }).columns.adjust();
      }
    }, 100); // slight delay ensures DOM is visible

    $('.payment-list-table').on('draw.dt', function () {
      var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
      var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl, {
          boundary: document.body
        });
      });
    });

    // Delete Record
    $('.payment-list-table tbody').on('click', '.delete-record', function () {
      dt_invoice.row($(this).parents('tr')).remove().draw();
    });

    // Filter form control to default size
    // ? setTimeout used for multilingual table initialization
    setTimeout(() => {
      $('.dataTables_filter .form-control').removeClass('form-control-sm');
      $('.dataTables_length .form-select').removeClass('form-select-sm');
    }, 300);
  });

  // On each datatable draw, initialize tooltip
  dt_payment_table.on('draw.dt', function () {
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
      return new bootstrap.Tooltip(tooltipTriggerEl, {
        boundary: document.body
      });
    });
  });

  // Delete Record
  $('.payment-list-table tbody').on('click', '.delete-record', function () {
    dt_invoice.row($(this).parents('tr')).remove().draw();
  });

  // Filter form control to default size
  // ? setTimeout used for multilingual table initialization
  setTimeout(() => {
    $('.dataTables_filter .form-control').removeClass('form-control-sm');
    $('.dataTables_length .form-select').removeClass('form-select-sm');
  }, 300);

  window.addEventListener('PaymentTrendsDataUpdated', function (event) {
    const data = event.detail[0].data;
    initPaymentTrendsChart(data.categories, data.amounts);
  });

  function initPaymentTrendsChart(categories, series) {
    const chartEl = document.querySelector('#PaymentTrendsChart');
    if (!chartEl) return;

    const allValues = series.flatMap(s => s.data);
    const maxValue = Math.max(...allValues);
    const yAxisMax = Math.ceil((maxValue * 1.2) / 10000) * 10000;

    const chartConfig = {
      series: series,
      chart: {
        height: 350,
        type: 'line',
        toolbar: { show: false }
      },
      stroke: {
        width: [3, 2],
        curve: 'smooth'
      },
      colors: [chartColors.line.series1, chartColors.line.series3],
      markers: {
        size: 6,
        strokeWidth: 0,
        hover: { size: 8 }
      },
      xaxis: {
        categories: categories,
        axisBorder: { show: false },
        axisTicks: { show: false },
        labels: {
          style: {
            colors: labelColor,
            fontSize: '13px'
          }
        }
      },
      yaxis: [
        {
          title: { text: 'Amount (₺)' },
          min: 0,
          max: yAxisMax,
          tickAmount: 5,
          labels: {
            formatter: function (val) {
              return val.toLocaleString() + ' ₺';
            }
          }
        },
        {
          opposite: true,
          title: { text: 'Count' },
          min: 0,
          tickAmount: 5
        }
      ],
      grid: {
        strokeDashArray: 8,
        borderColor: borderColor
      },
      legend: {
        position: 'bottom',
        horizontalAlign: 'center',
        fontSize: '14px',
        markers: {
          width: 8,
          height: 8,
          offsetX: -3
        }
      },
      tooltip: {
        y: {
          formatter: function (val, opts) {
            return opts.seriesIndex === 0 ? val.toLocaleString() + ' ₺' : val;
          }
        }
      },
      responsive: [
        {
          breakpoint: 1400,
          options: { chart: { height: 320 } }
        },
        {
          breakpoint: 1025,
          options: { chart: { height: 400 } }
        }
      ]
    };

    if (!paymentTrendsChart) {
      paymentTrendsChart = new ApexCharts(chartEl, chartConfig);
      paymentTrendsChart.render();
    } else {
      paymentTrendsChart.updateOptions(chartConfig);
    }
  }
  window.addEventListener('PaymentMethodsDataUpdated', function (event) {
    const data = event.detail[0].data;
    initPaymentMethodsChart(data.categories, data.amounts);
  });

  function initPaymentMethodsChart(categories, amounts) {
    const chartEl = document.querySelector('#PaymentMethodsChart');
    if (!chartEl) return;

    const methodNames = {
      1: 'Credit Card',
      2: 'Bank Transfer',
      3: 'Cash',
      4: 'Check',
      5: 'Online Payment'
    };

    const chartConfig = {
      series: amounts,
      chart: {
        height: 350,
        type: 'donut'
      },
      labels: categories.map(id => methodNames[id] || `Method ${id}`),
      colors: [
        chartColors.donut.series1,
        chartColors.donut.series2,
        chartColors.donut.series3,
        chartColors.donut.series4,
        chartColors.donut.series5
      ],
      stroke: { width: 0 },
      plotOptions: {
        pie: {
          donut: {
            size: '75%',
            labels: {
              show: true,
              value: {
                formatter: function (val) {
                  return val.toLocaleString() + ' ₺';
                }
              },
              total: {
                show: true,
                label: 'Total',
                formatter: function (w) {
                  return w.globals.seriesTotals.reduce((a, b) => a + b, 0).toLocaleString() + ' ₺';
                }
              }
            }
          }
        }
      },
      dataLabels: { enabled: false },
      legend: {
        position: 'bottom',
        fontSize: '14px',
        markers: { width: 8, height: 8 }
      },
      responsive: [
        {
          breakpoint: 992,
          options: { chart: { height: 300 } }
        }
      ]
    };

    if (!paymentMethodsChart) {
      paymentMethodsChart = new ApexCharts(chartEl, chartConfig);
      paymentMethodsChart.render();
    } else {
      paymentMethodsChart.updateOptions(chartConfig);
    }
  }
})();
