/**
 * Page Expense List
 */

'use strict';

// Datatable (jquery)
(function () {
  // Variable declaration for table
  var dt_expense_table = $('.datatables-expenses'),
    expenseView = baseUrl + 'app/expense/view/',
    offCanvasForm = $('#addExpenseModal');
  let currentChart = null;
  let expenseChart = null;
  // ajax setup
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  let borderColor, labelColor, headingColor, legendColor;
  const isDarkStyle = $('html').hasClass('dark-style') || $('html').hasClass('semi-dark-style');
  if (isDarkStyle) {
    borderColor = config.colors_dark.borderColor;
    labelColor = config.colors_dark.textMuted;
    headingColor = config.colors_dark.headingColor;
    legendColor = config.colors_dark.bodyColor;
  } else {
    borderColor = config.colors.borderColor;
    labelColor = config.colors.textMuted;
    headingColor = config.colors.headingColor;
    legendColor = config.colors.bodyColor;
  }

  // Chart Colors
  const chartColors = {
    donut: {
      series1: config.colors.success,
      series2: config.colors.primary,
      series3: config.colors.warning,
      series4: config.colors.danger,
      series5: '#7EDDA9',
      series6: '#A9E9C5'
    },
    line: {
      series1: config.colors.warning,
      series2: config.colors.primary,
      series3: '#7367f029'
    }
  };

  window.addEventListener('MonthlyPremiumChartUpdated', function (event) {
    console.log(event);
    var data = event.detail[0].data;
    var data = event.detail[0].data;
    var series = data['series'];
    var categories = data['categories'];
    console.log(series, categories);
    InitMonthlyPremiumChart(series, categories);
  });

  function InitMonthlyPremiumChart(series, categories) {
    const allValues = series.flatMap(s => s.data);
    const maxValue = Math.max(...allValues);
    const yAxisMax = Math.ceil((maxValue * 1.2) / 10000) * 10000;
    const chartEl = document.querySelector('#policiesTrendChart');
    if (!chartEl) return;

    if (currentChart) {
      currentChart.destroy();
    }

    const shipmentConfig = {
      series: series,
      chart: {
        height: 320,
        type: 'line',
        stacked: false,
        parentHeightOffset: 0,
        toolbar: { show: false },
        zoom: { enabled: false }
      },
      markers: {
        size: 5,
        colors: [config.colors.white],
        strokeColors: chartColors.line.series2,
        hover: { size: 6 },
        borderRadius: 4
      },
      stroke: {
        curve: 'smooth',
        width: [0, 3],
        lineCap: 'round'
      },
      legend: {
        show: true,
        position: 'bottom',
        markers: {
          width: 8,
          height: 8,
          offsetX: -3
        },
        height: 40,
        itemMargin: {
          horizontal: 10,
          vertical: 0
        },
        fontSize: '15px',
        fontFamily: 'Public Sans',
        fontWeight: 400,
        labels: {
          colors: headingColor,
          useSeriesColors: false
        },
        offsetY: 10
      },
      grid: {
        strokeDashArray: 8,
        borderColor
      },
      colors: [chartColors.line.series1, chartColors.line.series2],
      fill: {
        opacity: [1, 1]
      },
      plotOptions: {
        bar: {
          columnWidth: '30%',
          startingShape: 'rounded',
          endingShape: 'rounded',
          borderRadius: 4
        }
      },
      dataLabels: { enabled: false },
      xaxis: {
        tickAmount: 10,
        categories: categories,
        labels: {
          style: {
            colors: labelColor,
            fontSize: '13px',
            fontWeight: 400
          }
        },
        axisBorder: { show: false },
        axisTicks: { show: false }
      },
      yaxis: {
        min: 0,
        max: yAxisMax,
        tickAmount: 5,
        labels: {
          formatter: function (val) {
            return val.toLocaleString() + ' ₺';
          }
        }
      },
      responsive: [
        {
          breakpoint: 1400,
          options: {
            chart: { height: 320 },
            xaxis: { labels: { style: { fontSize: '10px' } } },
            legend: {
              itemMargin: {
                vertical: 0,
                horizontal: 10
              },
              fontSize: '13px',
              offsetY: 12
            }
          }
        },
        {
          breakpoint: 1025,
          options: {
            chart: { height: 415 },
            plotOptions: { bar: { columnWidth: '50%' } }
          }
        },
        {
          breakpoint: 982,
          options: { plotOptions: { bar: { columnWidth: '30%' } } }
        },
        {
          breakpoint: 480,
          options: {
            chart: { height: 250 },
            legend: { offsetY: 7 }
          }
        }
      ]
    };

    currentChart = new ApexCharts(chartEl, shipmentConfig);
    currentChart.render();
  }
  window.addEventListener('ExpiringPoliciesChartUpdated', function (event) {
    const data = event.detail[0].data;
    InitExpiringChart(data.amounts, data.categories);
  });

  function InitExpiringChart(series, categories) {
    const chartEl = document.querySelector('#expiringPoliciesChart');
    if (!chartEl) return;

    if (window.expiringChart) {
      window.expiringChart.destroy();
    }

    const options = {
      series: series,
      chart: {
        type: 'line',
        height: 300
      },
      xaxis: {
        categories: categories
      },
      stroke: {
        curve: 'smooth'
      },
      colors: ['#e67e22']
    };

    window.expiringChart = new ApexCharts(chartEl, options);
    window.expiringChart.render();
  }
})();
