

$(function () {
  'use strict';
  var   assetsPath = $('body').attr('data-asset-path');
  var map;
  var marker;
  const flatpickrDate = $('.flatpickrDate');
 
    flatpickrDate.flatpickr({
      monthSelectorType: 'static'
    });
  
  var image_icon =L.divIcon({
    iconUrl: assetsPath + 'images/router_map.png',
    className: 'custom-div-icon', // optional custom styling class
    iconSize: [32, 32],
    iconAnchor: [16, 32]
  });;
  var redLeaf = L.icon({
      iconUrl: assetsPath + 'images/router_map.png',
     
      iconSize: [50, 50],

      iconAnchor: [22, 94],
    
    });
    Livewire.dispatch('getIcon');
    window.addEventListener('SetIcon', function (event) {
       var iconAnchor = event.detail[0].icon;
 
       image_icon=L.divIcon({
        html:  iconAnchor,
        className: 'custom-div-icon', // optional custom styling class
        iconSize: [32, 32],
        iconAnchor: [16, 32],
 
        iconAnchor: [16, 32]
      });
    });

  function initializeLeafletMap(lat = 0, long = 0) {
      var userChange = true;
      if(lat==0 && long==0){
          
          lat=$("#latitude").val();
          long=$("#longitude").val();
      }
      map = L.map('map').setView([lat, long], 75);
      marker=L.marker([lat, long],{icon:image_icon});
       marker.addTo(map);
      L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {
          attribution: 'Map data &copy; <a href="https://www.openstreetmap.org/">OpenStreetMap</a>',
        
      }).addTo(map);

  }
  initializeLeafletMap()


 
  function updateMap() {
      // Get values from form fields
      var state = document.getElementById('state').value;
      var city = document.getElementById('city').value;
      var addressLine1 = document.getElementById('address_line1').value;
      var addressLine2 = document.getElementById('address_line2').value;
      var pincode = document.getElementById('pincode').value;

      // Concatenate address components
      var fullAddress = addressLine1 + ', ' + addressLine2 + ', ' + city + ', ' + state + ', ' + pincode;

      // Use a geocoding service to get latitude and longitude
      // This example uses the Nominatim geocoding service provided by OpenStreetMap
      var geocodingAPI = 'https://nominatim.openstreetmap.org/search?format=json&q=' + encodeURIComponent(fullAddress);

      // Make a request to the geocoding service
      fetch(geocodingAPI)
          .then(response => response.json())
          .then(data => {

              if (data.length > 0) {

                  $("#latitude").val(data[0].lat);
                  $("#longitude").val(data[0].lon);


                  if (marker) {
                      map.removeLayer(marker);
                  }
                  // Add a new marker to the map
                  marker = L.marker([data[0].lat, data[0].lon],{icon:image_icon}).addTo(map);
                  map.setView([data[0].lat, data[0].lon], 75);

              } else {

              }
          })
          .catch(error => {
              console.error('Error fetching geocoding data:', error);
          });
  }

  // Assuming 'map' and 'marker' are declared globally

  // Add a click event listener to the map
  map.on('click', function (e) {
     var  userChange = false;
      var clickedLatLng = e.latlng;

      // Update latitude and longitude fields


      // Remove existing marker
    //  if (marker) {
          map.removeLayer(marker);
       
      //}
      

      // Add a new marker to the clicked location
      marker = L.marker(clickedLatLng,{icon:image_icon}).addTo(map);

      // Use reverse geocoding to get address information based on the clicked coordinates
      var reverseGeocodingAPI = 'https://nominatim.openstreetmap.org/reverse?format=json&lat=' + clickedLatLng.lat + '&lon=' + clickedLatLng.lng;
      $("#longitude").val(clickedLatLng.lng)
      $("#latitude").val(clickedLatLng.lat)
      Livewire.dispatch('updateMap', { lat: clickedLatLng.lat, long: clickedLatLng.lng });
      fetch(reverseGeocodingAPI)
          .then(response => {
              if (!response.ok) {
                  throw new Error('Network response was not ok');
              }
              return response.json();
          })
          .then(data => {
         
          })
          .catch(error => {
              console.error('Error fetching reverse geocoding data:', error);
          }).finally(() => {
              // Set the flag back to true after the asynchronous operations are complete
              userChange = true;
          });
  });

 
 



  window.addEventListener("updateMap", event => {

      var lat = event.detail.lat;
      var long = event.detail.long;

      if (lat && long) {
          map.removeLayer(marker);
          map.setView([lat, long], 75);
          marker = L.marker([lat, long],{icon:image_icon}).addTo(map);
      }

  });
  window.addEventListener('tabChanged', (e) => {
    const tab = e.detail;
    Livewire.dispatch('render-topology');
    if (tab === 'topology') {
        alert(tab)
        
    } else if (tab === 'properties') {
        // Let DataTables hook re-init it (Livewire.hook will take care)
    }
});
  //Livewire.emit("updateMap");
});