/**
 *  Pages User Profile (jquery)
 */

'use strict';

(function () {
  let monthlypaymentChart;

  let borderColor, labelColor, headingColor, legendColor;
  const isDarkStyle = $('html').hasClass('dark-style') || $('html').hasClass('semi-dark-style');
  if (isDarkStyle) {
    borderColor = config.colors_dark.borderColor;
    labelColor = config.colors_dark.textMuted;
    headingColor = config.colors_dark.headingColor;
    legendColor = config.colors_dark.bodyColor;
  } else {
    borderColor = config.colors.borderColor;
    labelColor = config.colors.textMuted;
    headingColor = config.colors.headingColor;
    legendColor = config.colors.bodyColor;
  }

  // Chart Colors
  const chartColors = {
    donut: {
      series1: config.colors.success,
      series2: config.colors.primary,
      series3: config.colors.warning,
      series4: config.colors.danger,
      series5: '#7EDDA9',
      series6: '#A9E9C5'
    },
    line: {
      series1: config.colors.warning,
      series2: config.colors.primary,
      series3: '#7367f029'
    }
  };
  //  Projects table
  var dt_properties_table = $('.datatables-properties');
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });
  const flatpickrDate = $('.flatpickrDate');

  flatpickrDate.flatpickr({
    monthSelectorType: 'static'
  });

  window.addEventListener('InitializePaymentChartProperty', function (event) {
    var series = event.detail[0].data.series;
    var labels = event.detail[0].data.labels;

    InitializePaymentChart(labels, series);
  });
  function InitializePaymentChart(labels, series) {
    // Reasons for delivery exceptions Chart
    // --------------------------------------------------------------------
    const MonthlypaymentChartE1 = document.querySelector('#MonthlyRentPayments'),
      MonthlyPaymentChartConfig = {
        chart: {
          height: 420,
          parentHeightOffset: 0,
          type: 'bar',
          stacked: true
        },
        labels: labels,
        series: series,
        colors: [
          chartColors.donut.series1,
          chartColors.donut.series2,
          chartColors.donut.series3,
          chartColors.donut.series4
        ],
        stroke: {
          width: 0
        },
        dataLabels: {
          enabled: false,
          formatter: function (val, opt) {
            return parseInt(val);
          }
        },
        legend: {
          show: true,
          position: 'bottom',
          offsetY: 10,
          markers: {
            width: 8,
            height: 8,
            offsetX: -3
          },
          itemMargin: {
            horizontal: 15,
            vertical: 5
          },
          fontSize: '13px',
          fontFamily: 'Public Sans',
          fontWeight: 400,
          labels: {
            colors: headingColor,
            useSeriesColors: false
          }
        },
        tooltip: {
          theme: false
        },
        grid: {
          padding: {
            top: 15
          }
        },
        plotOptions: {
          pie: {
            donut: {
              size: '77%',
              labels: {
                show: true,
                value: {
                  fontSize: '24px',
                  fontFamily: 'Public Sans',
                  color: headingColor,
                  fontWeight: 500,
                  offsetY: -20,
                  formatter: function (val) {
                    return parseInt(val);
                  }
                },
                name: {
                  offsetY: 30,
                  fontFamily: 'Public Sans'
                },
                total: {
                  show: true,
                  fontSize: '15px',
                  fontFamily: 'Public Sans',
                  color: legendColor,

                  formatter: function (w) {
                    return parseInt(w.globals.seriesTotals.reduce((a, b) => a + b, 0));
                  }
                }
              }
            }
          }
        },
        responsive: [
          {
            breakpoint: 420,
            options: {
              chart: {
                height: 360
              }
            }
          }
        ]
      };
    if (typeof MonthlypaymentChartE1 !== undefined && MonthlypaymentChartE1 !== null) {
      const monthlypaymentChart = new ApexCharts(MonthlypaymentChartE1, MonthlyPaymentChartConfig);
      monthlypaymentChart.render();
    }
  }

  window.addEventListener('InitializePaidVsUnpaidChartProperty', function (event) {
    var series = event.detail[0].data.series;
    var labels = event.detail[0].data.labels;
    console.log(series, labels);
    const chartEl = document.querySelector('#PaidVsUnpaidChart');
    if (!chartEl) return;

    const chartConfig = {
      chart: {
        type: 'donut',
        height: 380
      },
      series: series,
      labels: labels,
      colors: [chartColors.donut.series1, chartColors.donut.series2],
      dataLabels: {
        enabled: true
      },
      legend: {
        position: 'bottom'
      }
    };

    const donutChart = new ApexCharts(chartEl, chartConfig);
    donutChart.render();
  });
  window.addEventListener('InitializeLeaseBreakdownChartProperty', function (event) {
    const series = event.detail[0].data.series;
    const categories = event.detail[0].data.labels;

    const chartEl = document.querySelector('#LeaseBreakdownChart');
    if (!chartEl) return;

    const chartConfig = {
      chart: {
        type: 'bar',
        height: 420,
        stacked: true,
        toolbar: { show: false }
      },
      series: series,
      xaxis: {
        categories: categories,
        labels: {
          style: { colors: '#6e6b7b' }
        }
      },
      plotOptions: {
        bar: {
          horizontal: false,
          dataLabels: { position: 'top' },
          barHeight: '60%'
        }
      },
      colors: [chartColors.donut.series1, chartColors.donut.series2, chartColors.donut.series3],
      legend: {
        position: 'bottom'
      },
      dataLabels: {
        enabled: false
      }
    };

    const chart = new ApexCharts(chartEl, chartConfig);
    chart.render();
  });
})();
