var theme = $('html').hasClass('light-style') ? 'default' : 'default-dark';
var type = $('#jstree-container').data('type');
var table_id = $('#jstree-container').data('table');
$(function () {
  $('#jstree-container').jstree({
    plugins: ['checkbox', 'search', 'types'],
    types: {
      default: {
        icon: 'ti ti-folder'
      }
    },
    checkbox: {
      keep_selected_style: true,
      three_state: false, // Only check what you select (not parent-child propagation)
      cascade: 'none' // Prevent auto-checking children or parents
    },
    core: {
      themes: {
        name: theme
      },
      data: {
        url: function (node) {
          return node.id === '#' ? '/Category/tree/nodes/' + type : '/Category/tree/nodes/' + type + '?id=' + node.id;
        },
        dataType: 'json'
      }
    },
    search: {
      show_only_matches: true,
      show_only_matches_children: true // optional: shows children of matched nodes
    }
  });
  let to = false;

  $('#tree-search').on('keyup', function () {
    if (to) clearTimeout(to);
    to = setTimeout(function () {
      let searchString = $('#tree-search').val();
      $('#jstree-container').jstree(true).search(searchString);
    }, 250);
  });
});

$('#jstree-container').on('changed.jstree', function (e, data) {
  const selectedNodes = data.selected;
  window.selectedCategoryIds = [];
  window.selectedSubcategoryIds = [];

  selectedNodes.forEach(id => {
    if (id.startsWith('cat_')) {
      window.selectedCategoryIds.push(id.replace('cat_', ''));
    } else if (id.startsWith('sub_')) {
      window.selectedSubcategoryIds.push(id.replace('sub_', ''));
    }
  });
  console.log(window.selectedCategoryIds, window.selectedSubcategoryIds);

  $('#' + table_id)
    .DataTable()
    .ajax.reload();
});
