/**
 *  Pages User Profile (jquery)
 */

'use strict';

(function () {
  let monthlyChart;
  let propertyTypeChart;
  let maintenanceCostChart;
  let ContractStatusChart;
  let topPropertiesChart;
  let borderColor, labelColor, headingColor, legendColor;
  const isDarkStyle = $('html').hasClass('dark-style') || $('html').hasClass('semi-dark-style');
  if (isDarkStyle) {
    borderColor = config.colors_dark.borderColor;
    labelColor = config.colors_dark.textMuted;
    headingColor = config.colors_dark.headingColor;
    legendColor = config.colors_dark.bodyColor;
  } else {
    borderColor = config.colors.borderColor;
    labelColor = config.colors.textMuted;
    headingColor = config.colors.headingColor;
    legendColor = config.colors.bodyColor;
  }

  // Chart Colors
  const chartColors = {
    donut: {
      series1: config.colors.success,
      series2: config.colors.primary,
      series3: config.colors.warning,
      series4: config.colors.danger,
      series5: '#7EDDA9',
      series6: '#A9E9C5'
    },
    line: {
      series1: config.colors.warning,
      series2: config.colors.primary,
      series3: '#7367f029'
    }
  };
  //  Projects table
  var dt_properties_table = $('.datatables-properties');
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });
  const flatpickrDate = $('.flatpickrDate');

  flatpickrDate.flatpickr({
    monthSelectorType: 'static'
  });

  window.addEventListener('InitializeContractStatusChart', function (event) {
    var series = event.detail[0].data.series;
    var labels = event.detail[0].data.labels;

    InitializeContractStatusChart(labels, series);
  });
  function InitializeContractStatusChart(labels, series) {
    // Reasons for delivery exceptions Chart
    // --------------------------------------------------------------------
    const deliveryExceptionsChartE1 = document.querySelector('#ContractStatusChart'),
      deliveryExceptionsChartConfig = {
        chart: {
          height: 420,
          parentHeightOffset: 0,
          type: 'donut'
        },
        labels: labels,
        series: series,
        colors: [
          chartColors.donut.series1,
          chartColors.donut.series2,
          chartColors.donut.series3,
          chartColors.donut.series4
        ],
        stroke: {
          width: 0
        },
        dataLabels: {
          enabled: false,
          formatter: function (val, opt) {
            return parseInt(val);
          }
        },
        legend: {
          show: true,
          position: 'bottom',
          offsetY: 10,
          markers: {
            width: 8,
            height: 8,
            offsetX: -3
          },
          itemMargin: {
            horizontal: 15,
            vertical: 5
          },
          fontSize: '13px',
          fontFamily: 'Public Sans',
          fontWeight: 400,
          labels: {
            colors: headingColor,
            useSeriesColors: false
          }
        },
        tooltip: {
          theme: false
        },
        grid: {
          padding: {
            top: 15
          }
        },
        plotOptions: {
          pie: {
            donut: {
              size: '77%',
              labels: {
                show: true,
                value: {
                  fontSize: '24px',
                  fontFamily: 'Public Sans',
                  color: headingColor,
                  fontWeight: 500,
                  offsetY: -20,
                  formatter: function (val) {
                    return parseInt(val);
                  }
                },
                name: {
                  offsetY: 30,
                  fontFamily: 'Public Sans'
                },
                total: {
                  show: true,
                  fontSize: '15px',
                  fontFamily: 'Public Sans',
                  color: legendColor,

                  formatter: function (w) {
                    return parseInt(w.globals.seriesTotals.reduce((a, b) => a + b, 0));
                  }
                }
              }
            }
          }
        },
        responsive: [
          {
            breakpoint: 420,
            options: {
              chart: {
                height: 360
              }
            }
          }
        ]
      };
    if (!ContractStatusChart) {
      ContractStatusChart = new ApexCharts(deliveryExceptionsChartE1, deliveryExceptionsChartConfig);
      ContractStatusChart.render();
    } else {
      ContractStatusChart.updateOptions(deliveryExceptionsChartConfig);
    }
  }
  window.addEventListener('InitializeDebtAgingChart', function (event) {
    if (monthlyChart) monthlyChart.destroy();
    var data = event.detail[0].data;
    console.log(data);

    monthlyChart = new ApexCharts(document.querySelector('#DebtAgingChart'), {
      chart: {
        type: 'bar',
        stacked: true,
        height: 400
      },
      colors: ['#1E90FF', '#FFA500'], // blue, orange-red
      series: data.series,
      xaxis: {
        categories: data.labels
      },
      plotOptions: {
        bar: {
          horizontal: false,
          columnWidth: '55%',
          endingShape: 'rounded'
        }
      },
      dataLabels: {
        enabled: false
      },
      stroke: {
        show: true,
        width: 2,
        colors: ['transparent']
      },
      tooltip: {
        y: {
          formatter: function (val) {
            return '₺' + val.toLocaleString();
          }
        }
      }
    });

    monthlyChart.render();
  });
  window.addEventListener('InitializeTopDebtors', function (event) {
    if (propertyTypeChart) propertyTypeChart.destroy();

    var data = event.detail[0].data;
    var Currency = event.detail[0].currency;
    propertyTypeChart = new ApexCharts(document.querySelector('#TopDebtorsChart'), {
      chart: {
        type: 'bar',
        stacked: true,
        height: 400
      },
      colors: ['#34A853', '#FB8C00'], // Green for count, Orange for rent
      series: data.series,
      xaxis: {
        categories: data.categories
      },
      plotOptions: {
        bar: {
          horizontal: false,
          columnWidth: '50%',
          endingShape: 'rounded'
        }
      },
      dataLabels: {
        enabled: true
      },
      tooltip: {
        y: { formatter: val => val.toLocaleString() + ' ' + Currency }
      }
    });

    propertyTypeChart.render();
  });
  window.addEventListener('InitializeMonthlyRentCollectionTrendChart', function (event) {
    if (maintenanceCostChart) maintenanceCostChart.destroy();

    const data = event.detail[0].data;

    maintenanceCostChart = new ApexCharts(document.querySelector('#MonthlyRentCollectionTrendChart'), {
      chart: {
        type: 'bar',
        height: 400
      },
      colors: ['#1E88E5'],
      series: data.series,
      xaxis: {
        categories: data.categories
      },
      plotOptions: {
        bar: {
          columnWidth: '50%',
          endingShape: 'rounded'
        }
      },
      dataLabels: {
        enabled: true,
        formatter: function (val) {
          return '₺' + val.toLocaleString();
        }
      },
      tooltip: {
        y: {
          formatter: function (val) {
            return '₺' + val.toLocaleString();
          }
        }
      }
    });

    maintenanceCostChart.render();
  });
  window.addEventListener('InitializeTenantsByPropertyTypeChart', function (event) {
    if (topPropertiesChart) topPropertiesChart.destroy();

    const data = event.detail[0].data;

    topPropertiesChart = new ApexCharts(document.querySelector('#tenantsByPropertyTypeChart'), {
      chart: {
        type: 'bar',
        height: 400,
        toolbar: {
          show: true,
          tools: {
            download: true
          }
        }
      },
      series: [
        {
          name: 'Tenants',
          data: data.series
        }
      ],
      xaxis: {
        categories: data.categories,
        title: {
          text: 'Property Type'
        }
      },
      yaxis: {
        title: {
          text: 'Number of Tenants'
        },
        min: 0
      },
      colors: ['#00C49F'],
      plotOptions: {
        bar: {
          columnWidth: '50%',
          borderRadius: 4,
          dataLabels: {
            position: 'top'
          }
        }
      },
      dataLabels: {
        enabled: true,
        formatter: function (val, { dataPointIndex }) {
          return data.series[dataPointIndex].percentage + '%';
        },
        offsetY: -20,
        style: {
          fontSize: '12px',
          colors: ['#333']
        }
      },
      tooltip: {
        custom: function ({ series, seriesIndex, dataPointIndex, w }) {
          const item = w.config.series[seriesIndex].data[dataPointIndex];
          return `
                <div class="p-2 bg-white border rounded shadow">
                    <div class="font-bold">${item.x}</div>
                    <div>Tenants: <b>${item.y}</b></div>
                    <div>Share: <b>${item.percentage}%</b></div>
                </div>`;
        }
      },
      annotations: {
        xaxis: [
          {
            x: data.categories[0],
            borderColor: '#999',
            label: {
              borderColor: '#999',
              style: {
                color: '#fff',
                background: '#999'
              },
              text: `Total: ${data.total} tenants`
            }
          }
        ]
      }
    });

    topPropertiesChart.render();
  });
  $('body').on('click', '#add-tenant-button', function (e) {
    e.preventDefault();

    $('#addTenantModal').modal('show');
  });
  window.addEventListener('filtersApplied', function (event) {
    const data = event.detail[0];

    const table = window.LaravelDataTables['tenant-table'];
    if (table) {
      // Stringify the filters object before storing
      window.filters = JSON.parse(JSON.stringify(data.filters));

      // Force a full reload
      table.ajax.reload();
    }
  });
})();
