'use strict';
(function () {
  const fullToolbar = [
    [{ font: [] }, { size: [] }],
    ['bold', 'italic', 'underline', 'strike'],
    [{ color: [] }, { background: [] }],
    [{ script: 'super' }, { script: 'sub' }],
    [{ header: '1' }, { header: '2' }, 'blockquote', 'code-block'],
    [{ list: 'ordered' }, { list: 'bullet' }, { indent: '-1' }, { indent: '+1' }],
    [{ direction: 'rtl' }],
    ['link', 'image', 'video', 'formula'],
    ['clean']
  ];

  const fullEditor = new Quill('#full-editor', {
    bounds: '#full-editor',
    placeholder: 'Type Something...',
    modules: {
      formula: true,
      toolbar: fullToolbar
    },
    theme: 'snow'
  });

  window.fullEditor = fullEditor; // Make editor accessible globally
  fullEditor.root.innerHTML = document.getElementById('quill-content').value || '';

  fullEditor.on('text-change', function () {
    const html = fullEditor.root.innerHTML;
    document.getElementById('quill-content').value = html;
    document.getElementById('quill-content').dispatchEvent(new Event('input'));
  });
  window.addEventListener('FillQuill', function (event) {
    var content = event.detail[0].content;

    fullEditor.root.innerHTML = content;
  });
  // ✅ Make this globally accessible
  window.insertVariable = function (variableKey) {
    const range = fullEditor.getSelection();
    if (!range) return;

    const variableMap = {
      company_name: 'Company Name',
      date: 'Date',
      based_balance: 'Based Balance'
    };

    const label = variableMap[variableKey] || variableKey;
    const spanHtml = `<span class="badge bg-primary" contenteditable="false" data-variable="${variableKey}">%${variableKey}%</span>`;

    fullEditor.clipboard.dangerouslyPasteHTML(range.index, spanHtml);
  };
  window.addEventListener('DOMContentLoaded', function () {
    fullEditor.root.innerHTML = document.getElementById('quill-content').value || '';
  });
})();
