<div class="d-flex justify-content-around">

    @if ($type == 'out')
        @if (!$data->isDelivered() && !$data->isReversed() && $data->status != 'cancelled' && $data->status != 'deleted')
            <button class="btn btn-sm btn-text-secondary rounded-pill btn-icon"
                x-on:click="$dispatch('editApproval', { id: '{{ $data->id }}' })" title="{{ __('actions.Edit') }}">
                <i class="tf-icons ti ti-pencil"></i>
            </button>
        @endif
        @can('View Audits')
            <button class="btn btn-sm btn-text-secondary rounded-pill btn-icon" title="{{ __('actions.ShowAudit') }}"
                x-on:click="$dispatch('ShowAudit', { model: 'LedgerApproval', model_id: {{ $data->id }} })">
                <i class="tf-icons ti ti-logs"></i>
            </button>
        @endcan

        <button class="btn btn-sm btn-text-secondary rounded-pill btn-icon" title="{{ __('actions.ShowReceipt') }}"
            x-on:click="$dispatch('ShowTransferReceipt', { transfer_id: '{{ $data->id }}' })">
            <i class="tf-icons ti ti-eye"></i>
        </button>

    @endif
    @if ($type == 'in')
        @if (!$data->isDelivered() && !$data->isReversed() && $data->status != 'cancelled' && $data->status != 'deleted')
            <a class="btn btn-sm btn-text-secondary rounded-pill btn-icon"
                href="/Transfers/DeliverTransfer/{{ $data->id }}" title="{{ __('actions.DeliverTransfer') }}">
                <i class="tf-icons ti ti-send-2"></i>
            </a>
        @endif
    @endif


</div>
