@extends('layouts/AgentLayoutMaster')


@section('title', 'تسليم الحوالة')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss'])

    @vite(['resources/assets/vendor/libs/select2/select2.scss'])
@endsection


@section('vendor-script')
    @vite(['resources/assets/vendor/libs/apex-charts/apexcharts.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js'])
    @vite(['resources/assets/vendor/libs/select2/select2.js'])
@endsection
@section('page-style')

@endsection

@section('content')

    <div class="col-12 col-xl-12 mb-4">
        <div class="card text-right mb-3 card-reload">
            <div wire:loading.flex wire:target="ChangeTab" class="loading-overlay">
                <div class="spinner-border text-primary" role="status"></div>
            </div>
            <div class="card-header">
                <ul class="nav nav-pills card-header-pills" role="tablist" style="background-color:#e9e7fd;">


                    <li class="nav-item">
                        <button type="button" class="nav-link  active " style="border-bottom: 4px #2babd5 solid;"
                            role="tab">
                            سحب حوالة
                        </button>
                    </li>
                </ul>
            </div>
            <div class="card-body">
                <div class="tab-content p-0">

                    <div class="tab-pane fade show active" id="tab-hawala" role="tabpanel">
                        <div class="row">
                            @livewire('agent-panel.transfer.deliver-transfer', ['transfer' => $transfer->toArray() ?? null])
                            <div class="col-xl-5 col-lg-5 col-md-6">

                                @livewire('client.show-info')


                                <div class="card-body">
                                    <h4 class="card-text text-uppercase text-center"> سعر الصرف</h4>

                                    <div class="card-body p-0">
                                        @livewire('exchange.exchange-prices')
                                    </div>

                                </div>

                                @livewire('exchange.syp-prices')
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>





    @livewire('attachment.add')

@endsection
