@extends('layouts/AgentLayoutMaster')

@php
    $breadcrumbs = [
        ['link' => 'home', 'name' => 'Home'],
        ['link' => 'javascript:void(0)', 'name' => 'User'],
        ['name' => 'Profile'],
    ];
@endphp
@section('title', $title)

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss'])@endsection

@section('vendor-script')
    @vite(['resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/pickr/pickr.js'])


@endsection

@section('page-script')



    {{ $dataTable->scripts(attributes: ['type' => 'module']) }}

@endsection
@section('page-style')

@endsection

@section('content')

    <livewire:components.filter-component model="App\Models\LedgerTransfer" :filters="$filters" table_id="transfer-table" />

    <div class="card">

        <div class="card-datatable table-responsive">
            {{ $dataTable->table(['style' => 'width:100%'], true) }}
        </div>
        <!-- Offcanvas to add new user -->

    </div>


    @livewire('transfers.show-transfer-receipt')
    @livewire('transfers.cancel-transfer')
    @livewire('attachment.add')
    @livewire('logs.audit')
    @livewire('transfers.show-transfer-media')
    @livewire('agent-panel.transfer.handle-cashier-booking')
@endsection
