@php
    use Illuminate\Support\Facades\Route;
    $configData = Helper::appClasses();
    $customizerHidden = 'customizer-hide';
    $configData = Helper::appClasses();
@endphp

@extends('layouts/blankLayout')

@section('title', 'Reset Password')

@section('page-style')
    @vite('resources/assets/vendor/scss/pages/page-auth.scss')
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }

        .password-container {
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            padding: 20px;
            width: 400px;
        }

        .password-container h2 {
            margin-bottom: 10px;
            font-size: 20px;
            text-align: center;
        }

        p {
            font-size: 14px;
            color: #666;
            text-align: center;
        }

        .password-container label {
            display: block;
            margin-top: 15px;
            font-weight: bold;
            font-size: 14px;
        }

        .password-container input {
            width: 100%;
            padding: 10px;
            margin: 5px 0;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 14px;
            box-sizing: border-box;
        }

        .password-container button {
            background-color: #6c63ff;
            color: white;
            border: none;
            padding: 10px 15px;
            font-size: 14px;
            border-radius: 4px;
            cursor: pointer;
            margin-top: 10px;
            width: 100%;
        }

        .password-container button:hover {
            background-color: #5753c9;
        }

        .strength-meter {
            height: 5px;
            width: 100%;
            background: lightgray;
            margin-top: 5px;
            border-radius: 3px;
        }

        .strength-meter div {
            height: 100%;
            width: 0%;
            transition: width 0.3s;
        }

        .weak {
            background: red;
        }

        .medium {
            background: orange;
        }

        .strong {
            background: green;
        }

        .error {
            color: red;
            font-size: 12px;
            text-align: left;
            margin: 5px 0 0;
        }

        .guide {
            font-size: 12px;
            color: #333;
            margin-top: 10px;
        }

        .guide ul {
            margin: 0;
            padding-left: 20px;
        }

        .guide li {
            list-style: none;
            margin: 5px 0;
            position: relative;
            padding-left: 20px;
        }

        .guide li::before {
            content: "\2713";
            position: absolute;
            left: 0;
            top: 0;
            color: red;
        }

        .guide li.valid::before {
            color: green;
        }
    </style>

    @livewireStyles
@endsection

@section('content')
    @livewire('agent-panel.auth.change-password')
@endsection

@section('vendor-script')

    @livewireScripts
@endsection

@section('page-script')
    <script>
        function validatePassword() {
            const password = document.getElementById("password").value;
            const confirmPassword = document.getElementById("confirm-password").value;
            const errorMessagePassword = document.getElementById("error-message-password");
            const errorMessageConfirm = document.getElementById("error-message-confirm");
            const regex = /^(?=.*[A-Z])(?=.*[a-z])(?=.*\d)(?=.*[@#$%^&*!]).{10,}$/;

            errorMessagePassword.innerHTML = "";
            errorMessageConfirm.innerHTML = "";

            if (!regex.test(password)) {
                errorMessagePassword.innerHTML = "Password must meet all the criteria above.";
                return false;
            }
            if (password !== confirmPassword) {
                errorMessageConfirm.innerHTML = "Passwords do not match.";
                return false;
            }
            alert("Password successfully updated!");
            return true;
        }

        function checkStrength() {
            const password = document.getElementById("password").value;
            const strengthBar = document.getElementById("strength-bar");
            const conditions = [{
                    id: "length",
                    valid: password.length >= 10
                },
                {
                    id: "uppercase",
                    valid: /[A-Z]/.test(password)
                },
                {
                    id: "lowercase",
                    valid: /[a-z]/.test(password)
                },
                {
                    id: "number",
                    valid: /\d/.test(password)
                },
                {
                    id: "special",
                    valid: /[@#$%^&*!]/.test(password)
                }
            ];

            let strength = 0;
            conditions.forEach(condition => {
                const element = document.getElementById(condition.id);
                if (condition.valid) {
                    element.classList.add("valid");
                    strength++;
                } else {
                    element.classList.remove("valid");
                }
            });

            if (strength <= 2) {
                strengthBar.style.width = "33%";
                strengthBar.className = "weak";
            } else if (strength === 3 || strength === 4) {
                strengthBar.style.width = "66%";
                strengthBar.className = "medium";
            } else if (strength === 5) {
                strengthBar.style.width = "100%";
                strengthBar.className = "strong";
            } else {
                strengthBar.style.width = "0%";
            }
        }
    </script>
@endsection
