@extends('layouts.layoutMaster')

@section('title', ' اضافة قيد جديد')

@section('vendor-style')
    @vite(['resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss', 'resources/assets/vendor/libs/apex-charts/apex-charts.scss', 'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss', 'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss', 'resources/assets/vendor/libs/select2/select2.scss', 'resources/assets/vendor/libs/@form-validation/form-validation.scss', 'resources/assets/vendor/libs/animate-css/animate.scss', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss', 'resources/assets/vendor/libs/bs-stepper/bs-stepper.scss', 'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/pickr/pickr-themes.scss'])@endsection

@section('vendor-script')
    @vite(['resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js', 'resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/@form-validation/popular.js', 'resources/assets/vendor/libs/@form-validation/bootstrap5.js', 'resources/assets/vendor/libs/@form-validation/auto-focus.js', 'resources/assets/vendor/libs/cleavejs/cleave.js', 'resources/assets/vendor/libs/cleavejs/cleave-phone.js', 'resources/assets/vendor/libs/sweetalert2/sweetalert2.js', 'resources/assets/vendor/libs/bs-stepper/bs-stepper.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js', 'resources/assets/vendor/libs/pickr/pickr.js'])


@endsection

@section('page-script')


    {{ $dataTable->scripts(attributes: ['type' => 'module']) }}

@endsection
@section('page-style')
    <style>
        #add-booking {
            display: none !important;
        }

        #search-booking {
            display: none !important;
        }
    </style>
@endsection

@section('content')
    <livewire:components.filter-component model="App\Models\LedgerBooking" :filters="$filters" table_id="booking-table" />

    @livewire('admin.form-field-config-manager', ['formName' => 'booking_form'])
    <div class="card">
        <div class="card-body">
            @livewire('booking.add', ['filters' => $filters, 'booking_id' => $id ?? null])
        </div>
    </div>
    @if (!isset($id))
        <div class="card">

            <div class="card-datatable table-responsive">
                {{ $dataTable->table(['style' => 'width:100%'], true) }}
            </div>
            <!-- Offcanvas to add new user -->

        </div>
        @livewire('logs.audit')
        @livewire('attachment.add')
        @livewire('logs.audit')
        @livewire('transfers.show-transfer-media')
        @livewire('transfers.show-transfer-receipt')
        @livewire('transfers.cancel-transfer')
    @endif
@endsection
