<div class="d-flex justify-content-around">
    @if (isset($type) && $type == 'actions')
        <button class="btn btn-sm btn-text-secondary rounded-pill btn-icon"
            x-on:click="$dispatch('editUser', { user_id: '{{ $data->id }}' })" title="{{ __('actions.Edit') }}">
            <i class="tf-icons ti ti-pencil"></i>
        </button>

        <button class="btn btn-sm btn-text-secondary rounded-pill btn-icon" title="{{ __('actions.Delete') }}"
            x-on:click="$dispatch('userDeleteAlaert', { id: '{{ $data->id }}' })">

            <i class="tf-icons ti ti-trash"></i>
        </button>

        <button class="btn btn-sm btn-text-secondary rounded-pill btn-icon" title="{{ __('actions.ShowAudit') }}"
            x-on:click="$dispatch('ShowAudit', { model: 'User', model_id: {{ $data->id }} })">
            <i class="tf-icons ti ti-logs"></i>
        </button>
    @elseif (isset($type) && $type == 'status')
        @php
            $extra = $data['status'] ?? null;

            $isChecked = !isset($data['status']) || $data['status'];
        @endphp

        <div x-data="{ checked: {{ $isChecked ? 'true' : 'false' }} }">
            <label class="switch">
                <input type="checkbox" x-model="checked"
                    @change="window.Livewire.dispatch('toggleChangeUserStatus', {
                value: '{{ $data['id'] }}',
                checked: checked
            })"
                    class="switch-input is-valid">

                <span class="switch-toggle-slider">
                    <span class="switch-on">on</span>
                    <span class="switch-off">off</span>
                </span>

                <span class="switch-label"
                    x-text="checked ? '{{ __('general.disable') }}' : '{{ __('general.enable') }}'"></span>
            </label>
        </div>
    @else
        <div x-data="{ checked: false }">
            <label class="switch">
                <input type="checkbox" x-model="checked"
                    @change="window.Livewire.dispatch('reset2fa', {
                    id: '{{ $data['id'] }}'
                })"
                    class="switch-input is-valid">

                <span class="switch-toggle-slider">
                    <span class="switch-on">Reset</span>
                    <span class="switch-off">Reset</span>
                </span>


            </label>
        </div>
    @endif


</div>
