@php
    use Illuminate\Support\Facades\Route;
    $configData = Helper::appClasses();
    $customizerHidden = 'customizer-hide';
    $configData = Helper::appClasses();
@endphp

@extends('layouts/blankLayout')

@section('title', 'Reset Password')

@section('page-style')
    @vite('resources/assets/vendor/scss/pages/page-auth.scss')
    @livewireStyles
    <style>
        /* Optional: smooth card shadow and rounded corners */
        .two-fa-card {
            border-radius: 1rem;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
        }

        .two-fa-card h4 {
            font-weight: 700;
        }

        .qr-code-container {
            display: flex;
            justify-content: center;
            margin: 2rem 0;
        }

        .recovery-codes li {
            font-family: monospace;
            padding: 0.25rem 0;
        }
    </style>
@endsection

@section('content')
    <div class="authentication-wrapper authentication-cover d-flex align-items-center justify-content-center"
        style="min-height:100vh; background: #f5f8fa;">
        <div class="authentication-inner w-100" style="max-width: 500px;">
            <div class="card two-fa-card p-4">
                <div class="card-header text-center border-0 pb-0">
                    <h4 class="card-title mb-1">{{ __('Set up Two-Factor Authentication') }} 🔐</h4>
                    <p class="card-text text-muted">Secure your account with Google Authenticator.</p>
                </div>
                <div class="card-body">
                    <p class="mb-2 text-center">Scan this QR code with Google Authenticator:</p>
                    <div class="qr-code-container">
                        {!! auth()->user()->twoFactorQrCodeSvg() !!}
                    </div>

                    <p class="text-center">Or enter this secret manually:</p>
                    <p class="text-center"><strong>{{ auth()->user()->two_factor_secret }}</strong></p>

                    <p class="mt-4 mb-2">Save your recovery codes:</p>
                    <ul class="recovery-codes list-unstyled">
                        @foreach (auth()->user()->recoveryCodes() as $code)
                            <li>{{ $code }}</li>
                        @endforeach
                    </ul>

                    <form method="POST" action="{{ route('two-factor.confirm') }}" class="mt-4 text-center">
                        @csrf
                        <label for="code" class="form-label">Enter the code from Google Authenticator</label>
                        <input type="text" name="code" id="code" class="form-control mb-2 mx-auto"
                            style="max-width:200px" required autofocus>
                        <button type="submit" class="btn btn-success mt-2">Confirm</button>
                    </form>

                </div>
            </div>
        </div>
    </div>
@endsection

@section('vendor-script')
@endsection

@section('page-script')
@endsection
