@extends('layouts.charity-module')

@section('title', 'Business Logic')

@section('content')
<div class="row">
    <div class="col-12">
        <h1>Charity Module Business Logic</h1>
        
        <div class="card">
            <div class="card-body">
                <h2>Overview</h2>
                <p>This section outlines the business logic for the charity module, detailing the processes, workflows, and rules that govern how the system handles charity budgets, allocations, and disbursements.</p>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">1. Budget Management</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="card bg-light-primary">
                            <div class="card-body">
                                <h5 class="card-title">1.1 Budget Creation</h5>
                                <p><strong>Process:</strong> Authorized users can create new charity budgets with target amounts</p>
                                <p><strong>Rules:</strong></p>
                                <ul>
                                    <li>Budget must have a name, target amount, and start date</li>
                                    <li>Budget can optionally have an end date</li>
                                    <li>Each budget can be associated with a specific expense category</li>
                                    <li>Each budget can have its own dedicated wallet or share a wallet with other budgets</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-light-warning">
                            <div class="card-body">
                                <h5 class="card-title">1.2 Budget Activation/Deactivation</h5>
                                <p><strong>Process:</strong> Budgets can be activated or deactivated by authorized users</p>
                                <p><strong>Rules:</strong></p>
                                <ul>
                                    <li>Inactive budgets cannot receive new allocations</li>
                                    <li>Inactive budgets cannot process new disbursements</li>
                                    <li>Historical data for inactive budgets remains accessible for reporting</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">2. Donation Handling</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="card bg-light-info">
                            <div class="card-body">
                                <h5 class="card-title">2.1 Conditional Donations</h5>
                                <p><strong>Process:</strong> When a conditional donation is received, it must be allocated to appropriate charity budget(s)</p>
                                <p><strong>Rules:</strong></p>
                                <ul>
                                    <li>System checks if donation is marked as conditional</li>
                                    <li>If conditional, system requires allocation to specific budget(s) matching the condition</li>
                                    <li>The donation_budget_allocations table tracks which donations fund which budgets</li>
                                    <li>If the specified budget doesn't exist, system allows creation of new budget</li>
                                    <li>Conditional donations cannot be reallocated to different budgets once assigned</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-light-success">
                            <div class="card-body">
                                <h5 class="card-title">2.2 Unconditional Donations</h5>
                                <p><strong>Process:</strong> Unconditional donations can be allocated to any charity budget at foundation's discretion</p>
                                <p><strong>Rules:</strong></p>
                                <ul>
                                    <li>System allows allocation to one or multiple budgets</li>
                                    <li>Allocation can be done at time of donation entry or later</li>
                                    <li>Partial allocations are allowed (e.g., splitting donation across multiple budgets)</li>
                                    <li>Unallocated donations remain in general fund until allocated</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mt-2">
                    <h5>2.3 Donation Allocation Workflow</h5>
                    <div class="card">
                        <div class="card-body">
                            <ul class="timeline">
                                <li class="timeline-item">
                                    <span class="timeline-point timeline-point-indicator"></span>
                                    <div class="timeline-event">
                                        <div class="d-flex justify-content-between flex-sm-row flex-column mb-sm-0 mb-1">
                                            <h6>Donation is received and entered into system</h6>
                                            <span class="timeline-event-time">Step 1</span>
                                        </div>
                                    </div>
                                </li>
                                <li class="timeline-item">
                                    <span class="timeline-point timeline-point-indicator"></span>
                                    <div class="timeline-event">
                                        <div class="d-flex justify-content-between flex-sm-row flex-column mb-sm-0 mb-1">
                                            <h6>System checks if donation is conditional or unconditional</h6>
                                            <span class="timeline-event-time">Step 2</span>
                                        </div>
                                    </div>
                                </li>
                                <li class="timeline-item">
                                    <span class="timeline-point timeline-point-indicator"></span>
                                    <div class="timeline-event">
                                        <div class="d-flex justify-content-between flex-sm-row flex-column mb-sm-0 mb-1">
                                            <h6>For conditional donations: User selects or creates matching budget</h6>
                                            <span class="timeline-event-time">Step 3a</span>
                                        </div>
                                    </div>
                                </li>
                                <li class="timeline-item">
                                    <span class="timeline-point timeline-point-indicator"></span>
                                    <div class="timeline-event">
                                        <div class="d-flex justify-content-between flex-sm-row flex-column mb-sm-0 mb-1">
                                            <h6>For unconditional donations: User can allocate immediately or later</h6>
                                            <span class="timeline-event-time">Step 3b</span>
                                        </div>
                                    </div>
                                </li>
                                <li class="timeline-item">
                                    <span class="timeline-point timeline-point-indicator"></span>
                                    <div class="timeline-event">
                                        <div class="d-flex justify-content-between flex-sm-row flex-column mb-sm-0 mb-1">
                                            <h6>System creates allocation record and updates budget's current_amount</h6>
                                            <span class="timeline-event-time">Step 4</span>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">3. Budget Allocation</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="card bg-light-primary">
                            <div class="card-body">
                                <h5 class="card-title">3.1 Allocation from Foundation Funds</h5>
                                <p><strong>Process:</strong> Foundation can allocate general funds to charity budgets</p>
                                <p><strong>Rules:</strong></p>
                                <ul>
                                    <li>Allocation source is marked as 'foundation_fund'</li>
                                    <li>System records which account funds came from</li>
                                    <li>Budget's current_amount is increased by allocation amount</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-light-info">
                            <div class="card-body">
                                <h5 class="card-title">3.2 Allocation from Donations</h5>
                                <p><strong>Process:</strong> Donations can be allocated to charity budgets</p>
                                <p><strong>Rules:</strong></p>
                                <ul>
                                    <li>Allocation source is marked as 'donation'</li>
                                    <li>System records which donation(s) funded the allocation</li>
                                    <li>Budget's current_amount is increased by allocation amount</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-light-success">
                            <div class="card-body">
                                <h5 class="card-title">3.3 Budget Transfers</h5>
                                <p><strong>Process:</strong> Funds can be transferred between charity budgets</p>
                                <p><strong>Rules:</strong></p>
                                <ul>
                                    <li>Source budget must have sufficient funds</li>
                                    <li>Source budget's current_amount is decreased</li>
                                    <li>Destination budget's current_amount is increased</li>
                                    <li>Transfer is recorded in budget_transfers table</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">4. Disbursement Management</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="card bg-light-primary">
                            <div class="card-body">
                                <h5 class="card-title">4.1 Disbursement Request</h5>
                                <p><strong>Process:</strong> Users can request disbursements from charity budgets</p>
                                <p><strong>Rules:</strong></p>
                                <ul>
                                    <li>Requested amount cannot exceed budget's available amount</li>
                                    <li>Request must include recipient, purpose, and amount</li>
                                    <li>Request is initially marked with 'pending' status</li>
                                    <li>Request is associated with specific budget</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-light-warning">
                            <div class="card-body">
                                <h5 class="card-title">4.2 Disbursement Approval Workflow</h5>
                                <ol>
                                    <li>Disbursement request is created with 'pending' status</li>
                                    <li>Authorized approver reviews request</li>
                                    <li>Approver can:
                                        <ul>
                                            <li>Approve request (status changes to 'approved')</li>
                                            <li>Reject request (status changes to 'cancelled')</li>
                                            <li>Request modifications (status remains 'pending' with notes)</li>
                                        </ul>
                                    </li>
                                    <li>Once approved, funds can be disbursed</li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-2">
                    <div class="col-md-6">
                        <div class="card bg-light-success">
                            <div class="card-body">
                                <h5 class="card-title">4.3 Disbursement Execution</h5>
                                <p><strong>Process:</strong> Approved disbursements are executed and funds are released</p>
                                <p><strong>Rules:</strong></p>
                                <ul>
                                    <li>Only approved disbursements can be executed</li>
                                    <li>When executed, status changes to 'disbursed'</li>
                                    <li>Budget's disbursed_amount is increased</li>
                                    <li>Transaction is recorded in wallet system if applicable</li>
                                    <li>Payment method and transaction details are recorded</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-light-info">
                            <div class="card-body">
                                <h5 class="card-title">4.4 Disbursement to Multiple Beneficiaries</h5>
                                <p><strong>Process:</strong> A single disbursement can be distributed among multiple beneficiaries</p>
                                <p><strong>Rules:</strong></p>
                                <ul>
                                    <li>Main disbursement record tracks total amount</li>
                                    <li>Individual beneficiary disbursements track specific allocations</li>
                                    <li>Sum of beneficiary disbursements must equal total disbursement amount</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">5. Wallet Integration</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="card bg-light-primary">
                            <div class="card-body">
                                <h5 class="card-title">5.1 Budget Wallets</h5>
                                <p><strong>Process:</strong> Each charity budget can have its own wallet or share a wallet with other budgets</p>
                                <p><strong>Rules:</strong></p>
                                <ul>
                                    <li>When budget is created, it can be associated with new or existing wallet</li>
                                    <li>All financial transactions for budget are tracked in associated wallet</li>
                                    <li>Wallet balance should match budget's (current_amount - disbursed_amount)</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-light-success">
                            <div class="card-body">
                                <h5 class="card-title">5.2 Allocation Transactions</h5>
                                <p><strong>Process:</strong> Budget allocations trigger wallet transactions</p>
                                <p><strong>Rules:</strong></p>
                                <ul>
                                    <li>When allocation is made, funds are transferred to budget's wallet</li>
                                    <li>Transaction ID is recorded in budget_allocations table</li>
                                    <li>For transfers between budgets, funds move between respective wallets</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card bg-light-danger">
                            <div class="card-body">
                                <h5 class="card-title">5.3 Disbursement Transactions</h5>
                                <p><strong>Process:</strong> Disbursements trigger wallet transactions</p>
                                <p><strong>Rules:</strong></p>
                                <ul>
                                    <li>When disbursement is executed, funds are withdrawn from budget's wallet</li>
                                    <li>Transaction ID is recorded in charity_disbursements table</li>
                                    <li>Wallet transaction includes payment method details</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">6. Reporting and Analytics</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 col-lg-3">
                        <div class="card bg-light-primary">
                            <div class="card-body">
                                <h5 class="card-title">6.1 Budget Utilization</h5>
                                <p>Reports show target amount, current amount, and disbursed amount with percentage utilization</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="card bg-light-info">
                            <div class="card-body">
                                <h5 class="card-title">6.2 Donation Allocation</h5>
                                <p>Reports show which donations funded which budgets and compliance with conditions</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="card bg-light-success">
                            <div class="card-body">
                                <h5 class="card-title">6.3 Disbursement Activity</h5>
                                <p>Reports show disbursements by status, date, recipient, or category with approval information</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="card bg-light-warning">
                            <div class="card-body">
                                <h5 class="card-title">6.4 Beneficiary Support</h5>
                                <p>Reports show which beneficiaries received what support, aggregated by various dimensions</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">7. Audit and Compliance</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="card bg-light-danger">
                            <div class="card-body">
                                <h5 class="card-title">7.1 Audit Trail</h5>
                                <p><strong>Process:</strong> System maintains comprehensive audit trail of all charity activities</p>
                                <p><strong>Rules:</strong></p>
                                <ul>
                                    <li>All budget changes are logged with user and timestamp</li>
                                    <li>All allocation changes are logged with user and timestamp</li>
                                    <li>All disbursement status changes are logged with user and timestamp</li>
                                    <li>Document uploads and changes are tracked</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card bg-light-secondary">
                            <div class="card-body">
                                <h5 class="card-title">7.2 Document Management</h5>
                                <p><strong>Process:</strong> System allows attachment of supporting documents</p>
                                <p><strong>Rules:</strong></p>
                                <ul>
                                    <li>Documents can be attached to budgets, allocations, or disbursements</li>
                                    <li>Document types are categorized for easy retrieval</li>
                                    <li>Documents are stored with secure access controls</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h4 class="card-title">8. User Permissions</h4>
            </div>
            <div class="card-body">
                <p>Different roles have different permissions in the charity module:</p>
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Role</th>
                                <th>Permissions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Budget Creators</td>
                                <td>Can create and manage budgets</td>
                            </tr>
                            <tr>
                                <td>Allocation Managers</td>
                                <td>Can allocate funds to budgets</td>
                            </tr>
                            <tr>
                                <td>Disbursement Requesters</td>
                                <td>Can request disbursements</td>
                            </tr>
                            <tr>
                                <td>Disbursement Approvers</td>
                                <td>Can approve disbursement requests</td>
                            </tr>
                            <tr>
                                <td>Reporters</td>
                                <td>Can view and generate reports</td>
                            </tr>
                            <tr>
                                <td>Administrators</td>
                                <td>Have full access to all functions</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
