@extends('layouts.charity-module')

@section('title', 'Overview')

@section('content')
<div class="row">
    <div class="col-12">
        <h1>Charity Module Design Overview</h1>
        
        <p class="mb-2">This documentation provides a comprehensive guide to the charity module design for the mulk takibi project. The module integrates with the existing system that manages properties, rent, and accounting using Laravel, Livewire, and the Bavix wallet package.</p>

        <h2>Design Components</h2>

        <div class="row match-height">
            <div class="col-md-6 col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <div>
                                <h4 class="font-weight-bolder mb-0">Requirements Analysis</h4>
                            </div>
                            <div class="avatar bg-light-primary p-50">
                                <div class="avatar-content">
                                    <i data-feather="clipboard" class="font-medium-4"></i>
                                </div>
                            </div>
                        </div>
                        <p class="card-text">Analysis of the foundation's needs for managing independent charity budgets, handling donations, and tracking disbursements.</p>
                        <a href="{{ route('charity-module.requirements') }}" class="btn btn-outline-primary">View Details</a>
                    </div>
                </div>
            </div>

            <div class="col-md-6 col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <div>
                                <h4 class="font-weight-bolder mb-0">Database Schema</h4>
                            </div>
                            <div class="avatar bg-light-success p-50">
                                <div class="avatar-content">
                                    <i data-feather="database" class="font-medium-4"></i>
                                </div>
                            </div>
                        </div>
                        <p class="card-text">Complete database design with tables for charity budgets, allocations, disbursements, and integration with existing systems.</p>
                        <a href="{{ route('charity-module.database') }}" class="btn btn-outline-primary">View Details</a>
                    </div>
                </div>
            </div>

            <div class="col-md-6 col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <div>
                                <h4 class="font-weight-bolder mb-0">Business Logic</h4>
                            </div>
                            <div class="avatar bg-light-danger p-50">
                                <div class="avatar-content">
                                    <i data-feather="settings" class="font-medium-4"></i>
                                </div>
                            </div>
                        </div>
                        <p class="card-text">Workflows and processes for budget management, donation allocation, disbursement approval, and reporting.</p>
                        <a href="{{ route('charity-module.business-logic') }}" class="btn btn-outline-primary">View Details</a>
                    </div>
                </div>
            </div>

            <div class="col-md-6 col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <div>
                                <h4 class="font-weight-bolder mb-0">Frontend Design</h4>
                            </div>
                            <div class="avatar bg-light-info p-50">
                                <div class="avatar-content">
                                    <i data-feather="layout" class="font-medium-4"></i>
                                </div>
                            </div>
                        </div>
                        <p class="card-text">UI designs for dashboards, budget management, disbursements, and reporting interfaces using Vuexy components.</p>
                        <a href="{{ route('charity-module.frontend-design') }}" class="btn btn-outline-primary">View Details</a>
                    </div>
                </div>
            </div>

            <div class="col-md-6 col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-1">
                            <div>
                                <h4 class="font-weight-bolder mb-0">User Flows & Wireframes</h4>
                            </div>
                            <div class="avatar bg-light-warning p-50">
                                <div class="avatar-content">
                                    <i data-feather="users" class="font-medium-4"></i>
                                </div>
                            </div>
                        </div>
                        <p class="card-text">Detailed wireframes and interaction patterns for all key processes in the charity module.</p>
                        <a href="{{ route('charity-module.user-flows') }}" class="btn btn-outline-primary">View Details</a>
                    </div>
                </div>
            </div>
        </div>

        <h2 class="mt-3">Implementation Steps</h2>
        
        <div class="card">
            <div class="card-body">
                <ul class="timeline">
                    <li class="timeline-item">
                        <span class="timeline-point timeline-point-indicator"></span>
                        <div class="timeline-event">
                            <div class="d-flex justify-content-between flex-sm-row flex-column mb-sm-0 mb-1">
                                <h6>Database Implementation</h6>
                                <span class="timeline-event-time">Step 1</span>
                            </div>
                            <p>Implement the database schema and migrations</p>
                        </div>
                    </li>
                    <li class="timeline-item">
                        <span class="timeline-point timeline-point-indicator"></span>
                        <div class="timeline-event">
                            <div class="d-flex justify-content-between flex-sm-row flex-column mb-sm-0 mb-1">
                                <h6>Models & Relationships</h6>
                                <span class="timeline-event-time">Step 2</span>
                            </div>
                            <p>Build the core models and relationships</p>
                        </div>
                    </li>
                    <li class="timeline-item">
                        <span class="timeline-point timeline-point-indicator"></span>
                        <div class="timeline-event">
                            <div class="d-flex justify-content-between flex-sm-row flex-column mb-sm-0 mb-1">
                                <h6>Business Logic Layer</h6>
                                <span class="timeline-event-time">Step 3</span>
                            </div>
                            <p>Implement the business logic with proper validation</p>
                        </div>
                    </li>
                    <li class="timeline-item">
                        <span class="timeline-point timeline-point-indicator"></span>
                        <div class="timeline-event">
                            <div class="d-flex justify-content-between flex-sm-row flex-column mb-sm-0 mb-1">
                                <h6>Frontend Components</h6>
                                <span class="timeline-event-time">Step 4</span>
                            </div>
                            <p>Create the frontend components using Vuexy</p>
                        </div>
                    </li>
                    <li class="timeline-item">
                        <span class="timeline-point timeline-point-indicator"></span>
                        <div class="timeline-event">
                            <div class="d-flex justify-content-between flex-sm-row flex-column mb-sm-0 mb-1">
                                <h6>Wallet Integration</h6>
                                <span class="timeline-event-time">Step 5</span>
                            </div>
                            <p>Integrate with the existing Bavix wallet system</p>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection
