@props([
    'name',
    'label' => '',
    'operators' => ['=' => '=', '<' => '<', '>' => '>', '<=' => '<=', '>=' => '>=', 'between' => 'Between'],
])

@php
    $operatorKey = $name . '_operator';
    $value1Key = $name . '_value1';
    $value2Key = $name . '_value2';
@endphp

<div class="mb-3">
    @if ($label)
        <label class="form-label">{{ $label }}</label>
    @endif

    <div x-data="{
        operator: @entangle('selectedFilters.' . $operatorKey).defer,
        init() {
            // Sync Alpine with Livewire when operator changes
            this.$watch('operator', (value) => {
                this.$wire.set('selectedFilters.{{ $operatorKey }}', value);
            });
        }
    }" class="d-flex gap-2 align-items-center">
        <!-- Value 1 -->
        <input type="text" class="form-control" placeholder="Value"
            wire:model.defer="selectedFilters.{{ $value1Key }}">

        <!-- Operator Select -->
        <select class="form-control w-auto" x-model="operator">
            @foreach ($operators as $key => $text)
                <option value="{{ $key }}">{{ $text }}</option>
            @endforeach
        </select>

        <!-- Value 2 (only shown when between is selected) -->
        <template x-if="operator === 'between'">
            <input type="text" class="form-control" placeholder="And"
                wire:model.defer="selectedFilters.{{ $value2Key }}">
        </template>
    </div>
</div>
