@extends('layouts.layoutMaster')

@section('title', 'تجربة نظام التحقق من التحويلات')

@section('vendor-style')
    <link rel="stylesheet" href="{{ asset('assets/vendor/libs/select2/select2.css') }}" />
@endsection

@section('page-style')
    <style>
        .validation-result {
            padding: 15px;
            border-radius: 8px;
            margin-top: 15px;
        }

        .validation-success {
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
        }

        .validation-error {
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
            color: #721c24;
        }

        .rule-info {
            background-color: #e2e3e5;
            border: 1px solid #d6d8db;
            color: #383d41;
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 15px;
        }

        .live-validation {
            border-left: 3px solid #007bff;
            padding-left: 15px;
            margin-top: 10px;
        }
    </style>
@endsection

@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            <i class="ti ti-shield-check me-2"></i>
                            تجربة نظام التحقق من التحويلات
                        </h4>
                        <p class="card-text">اختبر إعدادات التحقق من اسم المستفيد ورقم الهاتف</p>
                    </div>

                    <div class="card-body">
                        <!-- Current Rules Display -->
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="rule-info">
                                    <h6 class="text-primary">قواعد اسم المستفيد الحالية:</h6>
                                    <ul class="mb-0">
                                        <li><strong>الحد الأدنى:</strong> {{ $beneficiaryRules['min_words'] }} كلمة</li>
                                        <li><strong>الحد الأقصى:</strong> {{ $beneficiaryRules['max_words'] }} كلمة</li>
                                        <li><strong>مطلوب:</strong> {{ $beneficiaryRules['required'] ? 'نعم' : 'لا' }}</li>
                                        <li><strong>الأحرف الخاصة:</strong>
                                            {{ $beneficiaryRules['allow_special_chars'] ? 'مسموح' : 'غير مسموح' }}</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="rule-info">
                                    <h6 class="text-success">قواعد رقم الهاتف الحالية:</h6>
                                    <ul class="mb-0">
                                        <li><strong>الحد الأدنى:</strong> {{ $phoneRules['min_chars'] }} حرف</li>
                                        <li><strong>الحد الأقصى:</strong> {{ $phoneRules['max_chars'] }} حرف</li>
                                        <li><strong>مطلوب:</strong> {{ $phoneRules['required'] ? 'نعم' : 'لا' }}</li>
                                        <li><strong>التنسيق:</strong> {{ $phoneRules['format'] }}</li>
                                    </ul>
                                </div>
                            </div>
                        </div>

                        <!-- Demo Form -->
                        <form id="demoForm" class="needs-validation" novalidate>
                            @csrf

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="beneficiary_name" class="form-label">
                                            اسم المستفيد
                                            @if ($beneficiaryRules['required'])
                                                <span class="text-danger">*</span>
                                            @endif
                                        </label>
                                        <input type="text" class="form-control" id="beneficiary_name"
                                            name="beneficiary_name" placeholder="أدخل اسم المستفيد"
                                            data-min-words="{{ $beneficiaryRules['min_words'] }}"
                                            data-max-words="{{ $beneficiaryRules['max_words'] }}"
                                            data-allow-special="{{ $beneficiaryRules['allow_special_chars'] ? 'true' : 'false' }}">

                                        <div class="live-validation" id="beneficiary_validation" style="display: none;">
                                        </div>

                                        <div class="form-text">
                                            يجب أن يحتوي على {{ $beneficiaryRules['min_words'] }} إلى
                                            {{ $beneficiaryRules['max_words'] }} كلمة
                                            @if (!$beneficiaryRules['allow_special_chars'])
                                                (أحرف عربية أو إنجليزية فقط)
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="phone_number" class="form-label">
                                            رقم الهاتف
                                            @if ($phoneRules['required'])
                                                <span class="text-danger">*</span>
                                            @endif
                                        </label>
                                        <input type="text" class="form-control" id="phone_number" name="phone_number"
                                            placeholder="أدخل رقم الهاتف" data-min-chars="{{ $phoneRules['min_chars'] }}"
                                            data-max-chars="{{ $phoneRules['max_chars'] }}"
                                            data-format="{{ $phoneRules['format'] }}">

                                        <div class="live-validation" id="phone_validation" style="display: none;"></div>

                                        <div class="form-text">
                                            يجب أن يحتوي على {{ $phoneRules['min_chars'] }} إلى
                                            {{ $phoneRules['max_chars'] }} حرف
                                            @if ($phoneRules['format'] === 'international')
                                                (تنسيق دولي: +966501234567)
                                            @elseif($phoneRules['format'] === 'local')
                                                (تنسيق محلي: 0501234567)
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12">
                                    <div class="mb-3">
                                        <label for="notes" class="form-label">ملاحظات (اختياري)</label>
                                        <textarea class="form-control" id="notes" name="notes" rows="3" placeholder="أضف أي ملاحظات إضافية"></textarea>
                                    </div>
                                </div>
                            </div>

                            <div class="text-center">
                                <button type="submit" class="btn btn-primary btn-lg me-3">
                                    <i class="ti ti-check me-2"></i>
                                    اختبار التحقق
                                </button>

                                <button type="button" class="btn btn-outline-secondary btn-lg" onclick="resetForm()">
                                    <i class="ti ti-refresh me-2"></i>
                                    إعادة تعيين
                                </button>
                            </div>
                        </form>

                        <!-- Validation Results -->
                        <div id="validationResults" class="mt-4" style="display: none;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('vendor-script')
    <script src="{{ asset('assets/vendor/libs/select2/select2.full.min.js') }}"></script>
@endsection

@section('page-script')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.getElementById('demoForm');
            const beneficiaryInput = document.getElementById('beneficiary_name');
            const phoneInput = document.getElementById('phone_number');

            // Live validation for beneficiary name
            beneficiaryInput.addEventListener('input', function() {
                validateBeneficiaryName(this.value);
            });

            // Live validation for phone number
            phoneInput.addEventListener('input', function() {
                validatePhoneNumber(this.value);
            });

            // Form submission
            form.addEventListener('submit', function(e) {
                e.preventDefault();
                submitForm();
            });
        });

        function validateBeneficiaryName(name) {
            const validationDiv = document.getElementById('beneficiary_validation');
            const minWords = parseInt(beneficiaryInput.dataset.minWords);
            const maxWords = parseInt(beneficiaryInput.dataset.maxWords);
            const allowSpecial = beneficiaryInput.dataset.allowSpecial === 'true';

            if (!name.trim()) {
                validationDiv.style.display = 'none';
                return;
            }

            const words = name.trim().split(' ').filter(word => word.length > 0);
            const wordCount = words.length;

            let message = '';
            let isValid = true;

            if (wordCount < minWords) {
                message = `يجب أن يحتوي على ${minWords} كلمة على الأقل (الحالي: ${wordCount})`;
                isValid = false;
            } else if (wordCount > maxWords) {
                message = `يجب أن يحتوي على ${maxWords} كلمة كحد أقصى (الحالي: ${wordCount})`;
                isValid = false;
            } else if (!allowSpecial && !/^[\p{L}\s]+$/u.test(name)) {
                message = 'يجب أن يحتوي على أحرف عربية أو إنجليزية فقط';
                isValid = false;
            } else {
                message = `✅ صحيح (${wordCount} كلمة)`;
                isValid = true;
            }

            validationDiv.innerHTML = message;
            validationDiv.className = `live-validation ${isValid ? 'validation-success' : 'validation-error'}`;
            validationDiv.style.display = 'block';
        }

        function validatePhoneNumber(phone) {
            const validationDiv = document.getElementById('phone_validation');
            const minChars = parseInt(phoneInput.dataset.minChars);
            const maxChars = parseInt(phoneInput.dataset.maxChars);
            const format = phoneInput.dataset.format;

            if (!phone.trim()) {
                validationDiv.style.display = 'none';
                return;
            }

            const length = phone.length;
            let message = '';
            let isValid = true;

            if (length < minChars) {
                message = `يجب أن يحتوي على ${minChars} حرف على الأقل (الحالي: ${length})`;
                isValid = false;
            } else if (length > maxChars) {
                message = `يجب أن يحتوي على ${maxChars} حرف كحد أقصى (الحالي: ${length})`;
                isValid = false;
            } else {
                // Format validation
                let formatValid = true;
                switch (format) {
                    case 'international':
                        formatValid = /^\+\d{1,4}\d{6,14}$/.test(phone);
                        break;
                    case 'local':
                        formatValid = /^05\d{8}$/.test(phone);
                        break;
                    case 'flexible':
                        formatValid = /^[\d\s\-\+\(\)]+$/.test(phone);
                        break;
                }

                if (!formatValid) {
                    message = getFormatErrorMessage(format);
                    isValid = false;
                } else {
                    message = `✅ صحيح (${length} حرف)`;
                    isValid = true;
                }
            }

            validationDiv.innerHTML = message;
            validationDiv.className = `live-validation ${isValid ? 'validation-success' : 'validation-error'}`;
            validationDiv.style.display = 'block';
        }

        function getFormatErrorMessage(format) {
            switch (format) {
                case 'international':
                    return 'يجب أن يكون بالتنسيق الدولي (+966501234567)';
                case 'local':
                    return 'يجب أن يكون بالتنسيق المحلي (0501234567)';
                case 'flexible':
                    return 'يجب أن يحتوي على أرقام فقط';
                default:
                    return 'تنسيق غير صحيح';
            }
        }

        function submitForm() {
            const formData = new FormData(document.getElementById('demoForm'));

            fetch('{{ route('demo.transfer-validation.process') }}', {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value
                    }
                })
                .then(response => response.json())
                .then(data => {
                    const resultsDiv = document.getElementById('validationResults');

                    if (data.success) {
                        resultsDiv.innerHTML = `
                <div class="validation-result validation-success">
                    <h5><i class="ti ti-check-circle me-2"></i>تم التحقق بنجاح!</h5>
                    <p>${data.message}</p>
                    <hr>
                    <h6>البيانات المدخلة:</h6>
                    <ul>
                        <li><strong>اسم المستفيد:</strong> ${data.data.beneficiary_name}</li>
                        <li><strong>رقم الهاتف:</strong> ${data.data.phone_number}</li>
                    </ul>
                </div>
            `;
                    } else {
                        let errorsHtml = '<ul>';
                        Object.keys(data.errors).forEach(field => {
                            data.errors[field].forEach(error => {
                                errorsHtml += `<li>${error}</li>`;
                            });
                        });
                        errorsHtml += '</ul>';

                        resultsDiv.innerHTML = `
                <div class="validation-result validation-error">
                    <h5><i class="ti ti-x-circle me-2"></i>فشل في التحقق</h5>
                    <p>يرجى تصحيح الأخطاء التالية:</p>
                    ${errorsHtml}
                </div>
            `;
                    }

                    resultsDiv.style.display = 'block';
                    resultsDiv.scrollIntoView({
                        behavior: 'smooth'
                    });
                })
                .catch(error => {
                    console.error('Error:', error);
                    document.getElementById('validationResults').innerHTML = `
            <div class="validation-result validation-error">
                <h5><i class="ti ti-alert-circle me-2"></i>خطأ في النظام</h5>
                <p>حدث خطأ أثناء معالجة الطلب. يرجى المحاولة مرة أخرى.</p>
            </div>
        `;
                    document.getElementById('validationResults').style.display = 'block';
                });
        }

        function resetForm() {
            document.getElementById('demoForm').reset();
            document.getElementById('beneficiary_validation').style.display = 'none';
            document.getElementById('phone_validation').style.display = 'none';
            document.getElementById('validationResults').style.display = 'none';
        }
    </script>
@endsection
