<div>
    {{-- Select/Clear All Controls --}}
    <div class="d-flex justify-content-end mb-3">
        <button class="btn btn-sm btn-outline-primary me-2" wire:click="selectAllCurrencies">
            {{ __('general.select_all') }}
        </button>



    </div>

    <div class="row g-3 pb-4">
        @foreach ($statistics as $currencyCode => $stat)
            <div class="col-6 col-sm-4 col-md-3 col-lg-2">
                <div class="card h-100 shadow-sm position-relative">

                    {{-- Filter Checkbox --}}
                    <div class="form-check position-absolute currency-filter-checkbox"
                        style="top: 0.5rem; right: 0.5rem; z-index: 1;">
                        <input type="checkbox" class="form-check-input" id="filter_{{ $currencyCode }}"
                            value="{{ $currencyCode }}" wire:model="selectedCurrencies" wire:click="$refresh">
                    </div>

                    <div class="card-body p-3 d-flex flex-column align-items-center text-center">
                        <span
                            class="badge bg-label-primary rounded-circle d-inline-flex align-items-center justify-content-center fw-bold mb-2 currency-badge"
                            style="width: 2.5rem; height: 2.5rem; font-size: 1rem; min-width: 2.5rem;">
                            {{ $currencyCode }}
                        </span>

                        <h6 class="mb-1 text-truncate w-100" title="{{ $stat['currency_name'] }}">
                            {{ $stat['currency_name'] }}
                        </h6>

                        <p class="mb-1 small text-success w-100">
                            {{ __('general.debit') }}:
                            <strong>{!! format_money($stat['positive_balance'], $currencyCode) !!}</strong>
                        </p>

                        <p class="mb-0 small text-danger w-100">
                            {{ __('general.credit') }}:
                            <strong>{!! format_money($stat['negative_balance'], $currencyCode) !!} </strong>
                        </p>
                    </div>
                </div>
            </div>
        @endforeach
    </div>

    {{-- Mobile style fix --}}
    <style>
        @media (max-width: 576px) {
            .currency-badge {
                width: 2rem !important;
                height: 2rem !important;
                font-size: 0.85rem !important;
            }
        }
    </style>
    <div id="written_balance_reconciliation_content" style="display: none">{!! $html !!}</div>
</div>
