<div>

    <div class="class="authentication-wrapper authentication-cover"">
        <div class="auth-inner py-2" style="min-width:500px">
            <!-- Reset Password v1 -->
            <div class="card mb-0">
                <div class="card-header d-flex justify-content-center">

                </div>
                <div class="card-body">
                    <a href="javascript:void(0);" class="brand-logo">
                        <h4 class="card-title mb-1">{{ __('Change Password') }} 🔒</h4>
                    </a>
                    <p class="card-text mb-2">
                        {{ __('Your new password must be different from previously used passwords.') }}</p>


                    <form class="auth-reset-password-form mt-2 p-2">
                        @csrf


                        <div class="form-group">
                            <div class="d-flex justify-content-between">
                                <label for="reset-password-new"><strong>{{ __('New Password') }}</strong></label>
                            </div>
                            <div class="input-group input-group-merge">
                                <input type="password" wire:model="password" id="password" oninput="checkStrength()"
                                    class="form-control @error('password') is-invalid @enderror" name="password"
                                    placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                    aria-describedby="password" autofocus />
                                <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                            </div>

                        </div>
                        <div class="strength-meter " wire:ignore>
                            <div id="strength-bar"></div>
                        </div>
                        <div class="guide" wire:ignore>

                            <ul>
                                <li id="length">{{ __('At least 10 characters') }}</li>
                                <li id="uppercase">{{ __('uppercase letter (A-Z)') }}</li>
                                <li id="lowercase">{{ __('lowercase letter (a-z)') }}</li>
                                <li id="number">{{ __('One number (0-9)') }}</li>
                                <li id="special">{{ __('One special character (@, #, $, %, &, *, !, etc.)') }}</li>
                            </ul>
                        </div>
                        @error('password')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                        <div class="form-group">
                            <div class="d-flex justify-content-between">
                                <label for="reset-password-new"><strong> {{ __('Confirm Password') }}</strong></label>
                            </div>
                            <div class="input-group input-group-merge">
                                <input type="password" wire:model="password_confirmation" autocomplete="new-password"
                                    class="form-control @error('password_confirmation') is-invalid @enderror"
                                    name="password_confirmation"
                                    placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                    aria-describedby="password" autofocus />
                                <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                            </div>

                        </div>
                </div>





                <button type="button" class="btn btn-primary btn-block" tabindex="4"
                    wire:click="ChangePassword">{{ __('actions.save') }}</button>
                </form>


            </div>
        </div>

    </div>
</div>
