<div>



    <form id="booking_form" wire:submit.prevent="confirmTransfer">
        <div class="row mb-4">
            <!-- Sender Section -->
            <div class="col-md mb-4 mb-md-0">
                <div class="card">
                    <h5 class="card-header-title">
                        {{ __('transfers.debit') }} <span
                            class="amount-inline text-success">{!! PriceFormat($transfer['amount'] + (float) $transfer['send_fee'] ?? 0, $transfer['currency']) !!}</span>
                    </h5>
                    <div class="card-body">
                        <div class="mb-3  ">
                            <div class="dropdown">
                                <i class="ti ti-tag cursor-pointer" id="dropdownLabel1" data-bs-toggle="dropdown"
                                    aria-haspopup="true" aria-expanded="false" style="color :red;"></i>
                                <div class="dropdown-menu dropdown-menu-start" aria-labelledby="dropdownLabel1"
                                    style="padding: 20px;">
                                    <x-balance-badges :balances="$this->getBalances($transfer['sender_id'])" :limit="2000" :basebalance="getBaseCurrencyBalance($this->getBalances($transfer['sender_id']))"
                                        basecurrency="USD" />
                                </div>
                            </div>
                        </div>
                        <div class="mb-3 select2_content">

                            <label
                                class="form-label">{{ $this->getFieldLabel('transfer.sender_id') ?? __('transfers.select_sender') }}:</label>

                            <x-Mulk.ajax-select2 wire:model.live="transfer.sender_id" searchUrl="/home"
                                placeholder="Select Account"
                                search-url="/Accounts/AgentSearch?type={{ $type }}&direction=sender" />
                            @error('transfer.sender_id')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                            <div class="dark-red-text text-danger" style="font-weight: bold;">
                                {{ $senderDetails['name'] ?? '' }}
                            </div>
                        </div>


                        <div class="mb-3 select2_content">
                            <label
                                class="form-label">{{ $this->getFieldLabel('transfer.currency') ?? __('transfers.currency') }}:</label>
                            <x-Mulk.select2 wire:model="transfer.currency" class="form-select">
                                @foreach ($currencies as $currency)
                                    <option value="{{ $currency->code }}">{{ $currency->name }}</option>
                                @endforeach
                            </x-Mulk.select2>
                        </div>

                        <label
                            class="form-label">{{ $this->getFieldLabel('transfer.amount') ?? __('transfers.amount_to_send') }}
                            <i class="fas fa-exchange-alt fa-s btn-outline-primary" data-bs-toggle="tooltip"
                                data-bs-placement="top" data-bs-custom-class="tooltip-primary" title="تقريب"
                                style="cursor: pointer;" wire:click="RoundAmount('amount')"></i></label>


                        <x-decimal-input name="transfer.amount" model="transfer.amount" placeholder="0.00" required
                            wire:model.lazy="transfer.amount" min="0.01" max="9999.99" style="width: 100%" />
                        @error('transfer.amount')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                        <div class="yellow-box mt-2">{{ $this->amountInWords }}</div>
                        <label
                            class="form-label">{{ $this->getFieldLabel('transfer.send_fee') ?? __('transfers.transfer_fee') }}</label>
                        <div class="input-group">
                            <div class="dropdown">
                                <button class="btn btn-outline-primary dropdown-toggle" type="button"
                                    id="feeTypeDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                    {{ __("transfers.$send_fee_type") ?? ($send_fee_type ?? __('transfers.fee_types')) }}
                                </button>
                                <ul class="dropdown-menu" aria-labelledby="feeTypeDropdown">
                                    <li><a class="dropdown-item" href="javascript:void(0);"
                                            wire:click="$set('send_fee_type', 'fixed')">أجور ثابتة</a></li>
                                    <li><a class="dropdown-item" href="javascript:void(0);"
                                            wire:click="$set('send_fee_type', 'percent_hundred')">نسبة بالمئة</a>
                                    </li>
                                    <li><a class="dropdown-item" href="javascript:void(0);"
                                            wire:click="$set('send_fee_type', 'percent_thousand')">نسبة بالألف</a>
                                    </li>
                                    <li><a class="dropdown-item" href="javascript:void(0);"
                                            wire:click="$set('send_fee_type', 'percent_ten_thousand')">نسبة بالعشر
                                            ألاف</a></li>
                                </ul>
                            </div>

                            <div class="flex-grow-1">
                                <x-decimal-input name="send_fee" model="transfer.send_fee_value" placeholder="0.00"
                                    required wire:model.lazy="transfer.send_fee_value" min="0.01" max="9999.99"
                                    style="width: 100%" />
                            </div>


                        </div>
                        <div class="yellow-box mt-2">
                            {{ $this->getAmountInWords($transfer['send_fee'], $transfer['currency']) }}
                        </div>
                        @if ($this->fieldIsVisible('transfer.receiver_id'))
                            <div class="mb-3 select2_content">
                                <label
                                    class="form-label">{{ $this->getFieldLabel('transfer.receiver_id') ?? __('transfers.receiver_client') }}</label>
                                <input type="text" class="form-control" wire:model="recipient.name" />
                                @error('recipient.name')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        @endif

                        <label class="form-label">{{ __('transfers.notes') }}</label>
                        <input type="text" class="form-control" wire:model.lazy="transfer.notes" />
                        @if ($this->fieldIsVisible('transfer.exchange_rate'))
                            <div class="d-flex align-items-center gap-3 mb-3 mt-5">

                                <input type="number" class="form-control" wire:model.lazy="transfer.exchange_rate" />
                                <select class="form-select" wire:model.live="factor">
                                    <option value="multiply">ضرب</option>
                                    <option value="divide">قسمة</option>
                                </select>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Receiver Section -->
            <div class="col-md mb-4 mb-md-0">
                <div class="card">
                    <h5 class="card-header-title">
                        {{ __('transfers.credit') }}
                        @if ($transfer['delivery_amount'] > 0)
                            <span class="amount-inline text-danger">{!! PriceFormat($transfer['delivery_amount'], $transfer['delivery_currency']) !!}</span>
                            {{ __('transfers.profit') }} <span
                                class="amount-inline text-success">{!! PriceFormat(
                                    CalculateRevenue($transfer['amount'], $transfer['send_fee'], $transfer['receiver_fee']),
                                    $transfer['currency'],
                                ) !!}</span>
                        @endif
                    </h5>
                    <div class="card-body">
                        <div class="mb-3  select2_content">

                            <div class="dropdown">
                                <i class="ti ti-tag cursor-pointer" id="dropdownLabel1" data-bs-toggle="dropdown"
                                    aria-haspopup="true" aria-expanded="false" style="color :red;"></i>
                                <div class="dropdown-menu dropdown-menu-start" aria-labelledby="dropdownLabel1"
                                    style="padding: 20px;">
                                    <x-balance-badges :balances="$this->getBalances($transfer['receiver_id'])" :limit="2000" :basebalance="getBaseCurrencyBalance($this->getBalances($transfer['receiver_id']))" />
                                </div>
                            </div>
                        </div>
                        <div class="mb-3 select2_content">
                            <label
                                class="form-label">{{ $this->getFieldLabel('transfer.receiver_id') ?? __('transfers.select_receiver') }}:</label>
                            <x-Mulk.ajax-select2 wire:model.live="transfer.receiver_id" searchUrl="/home"
                                placeholder="Select Account"
                                search-url="/Accounts/AgentSearch?type={{ $type }}&direction=receiver" />
                            @error('transfer.receiver_id')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                            <div class="dark-red-text text-danger" style="font-weight: bold;">
                                {{ $receiverDetails['name'] ?? '' }}
                            </div>
                        </div>
                        <div class="mb-3 select2_content">

                            <label
                                class="form-label">{{ $this->getFieldLabel('transfer.delivery_currency') ?? __('transfers.currency') }}</label>
                            <x-Mulk.select2 wire:model.defer="transfer.delivery_currency" class="form-select">
                                @foreach ($currencies as $currency)
                                    <option value="{{ $currency->code }}">{{ $currency->name }}</option>
                                @endforeach
                            </x-Mulk.select2>
                            @error('transfer.delivery_currency')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <label
                            class="form-label">{{ $this->getFieldLabel('transfer.delivery_amount') ?? __('transfers.total_to_receive') }}
                            <i class="fas fa-exchange-alt fa-s btn-outline-primary" data-bs-toggle="tooltip"
                                data-bs-placement="top" data-bs-custom-class="tooltip-primary" title="تقريب"
                                style="cursor: pointer;" wire:click="RoundAmount('delivery_amount')"></i></label>
                        <x-decimal-input name="delivery_amount" model="transfer.delivery_amount" placeholder="0.00"
                            required wire:model.lazy="transfer.delivery_amount" min="0.01" max="9999.99"
                            style="width: 100%" />
                        @error('transfer.delivery_amount')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                        <div class="yellow-box mt-2">
                            {{ $this->getAmountInWords($transfer['delivery_amount'], $transfer['delivery_currency']) }}
                        </div>
                        <label
                            class="form-label">{{ $this->getFieldLabel('transfer.receiver_fee') ?? __('transfers.delivery_fee') }}</label>

                        <div class="input-group">
                            <div class="dropdown">
                                <button class="btn btn-outline-primary dropdown-toggle" type="button"
                                    id="feeTypeDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                    {{ __("transfers.$receiver_fee_type") ?? ($receiver_fee_type ?? __('transfers.fee_types')) }}
                                </button>
                                <ul class="dropdown-menu" aria-labelledby="feeTypeDropdown">
                                    <li><a class="dropdown-item" href="javascript:void(0);"
                                            wire:click="$set('receiver_fee_type', 'fixed')">أجور ثابتة</a></li>
                                    <li><a class="dropdown-item" href="javascript:void(0);"
                                            wire:click="$set('receiver_fee_type', 'percent_hundred')">نسبة بالمئة</a>
                                    </li>
                                    <li><a class="dropdown-item" href="javascript:void(0);"
                                            wire:click="$set('receiver_fee_type', 'percent_thousand')">نسبة بالألف</a>
                                    </li>
                                    <li><a class="dropdown-item" href="javascript:void(0);"
                                            wire:click="$set('receiver_fee_type', 'percent_ten_thousand')">نسبة بالعشر
                                            ألاف</a></li>
                                </ul>
                            </div>

                            <div class="flex-grow-1">
                                <x-decimal-input name="receiver_fee" model="transfer.receiver_fee_value"
                                    placeholder="0.00" required wire:model.live="transfer.receiver_fee_value"
                                    min="0.01" max="9999.99" style="width: 100%" />
                            </div>


                        </div>
                        <div class="yellow-box mt-2">
                            {{ $this->getAmountInWords($transfer['receiver_fee'], $transfer['delivery_currency']) }}
                        </div>




                        @if ($this->fieldIsVisible('transfer.date'))
                            <label
                                class="form-label">{{ $this->getFieldLabel('transfer.date') ?? __('transfers.date') }}</label>
                            <x-Mulk.date class="form-control" max="today" wire:model="transfer.date" />
                        @endif
                        <label
                            class="form-label">{{ $this->getFieldLabel('transfer.receiver_note') ?? __('transfers.notes') }}</label>
                        <input type="text" class="form-control" wire:model.defer="transfer.receiver_note" />
                        @livewire('components.attachments-repeater')
                        <div class="d-flex justify-content-center gap-3 col-6 mx-auto mt-4">
                            <button type="button" class="btn btn-secondary" wire:click="cancel">
                                {{ __('actions.cancel') }}
                            </button>
                            <button type="submit" class="btn btn-primary">
                                @if (isset($transfer['id']))
                                    {{ __('actions.edit') }}
                                @else
                                    {{ __('transfers.confirm_transfer') }}
                                @endif
                            </button>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </form>


</div>
