 <div class="col-xl-7 col-lg-7 col-md-6">

     <form class="card-body" wire:submit.prevent="sendConfirm">

         <div class="row g-3">
             <div class="col-12 d-flex justify-content-center align-items-center mb-3">
                 <img src="{{ $logo }}" class="img-fluid" style="max-height: 100px; width: auto">
             </div>

             <div class="col-md-12">
                 <label class="form-label"> الشركة </label>
                 <select class="select2 form-select" data-allow-clear="true" wire:model.live="company">

                     @foreach ($companies as $key => $value)
                         <option value="{{ $value }}">{{ $key }}</option>
                     @endforeach
                 </select>
             </div>
             <div class="col-md-6 select2_content">
                 <label class="form-label"> العملة </label>
                 <x-Mulk.select2 class="select2 form-select" wire:model.live="approval.currency"
                     data-allow-clear="true">
                     <option value="">{{ __('general.select') }}</option>
                     @foreach ($currencies as $currency)
                         <option value="{{ $currency->code }}">{{ $currency->name }}</option>
                     @endforeach
                 </x-Mulk.select2>
                 @error('approval.currency')
                     <span class="text-danger">{{ $message }}</span>
                 @enderror
             </div>

             <div class="col-md-6">
                 <label class="form-label"> المبلغ </label>
                 <input type="number" class="form-control" placeholder="100" wire:model.lazy="approval.amount" />
                 @error('approval.amount')
                     <span class="text-danger">{{ $message }}</span>
                 @enderror
             </div>


             <div class="col-md-12 select2_content">
                 <label class="form-label"> الصندوق </label>
                 <x-Mulk.live_search wire:model="approval.receiver_account_code" :search-url="$url"
                     placeholder="Select Account" />




                 @error('approval.receiver_account_code')
                     <span class="text-danger">{{ $message }}</span>
                 @enderror
             </div>
             <div class="col-md-12">
                 <label class="form-label"> ملاحظات </label>
                 <textarea class="form-control" placeholder="ملاحظات" wire:model="approval.notes"></textarea>
                 @error('approval.notes')
                     <span class="text-danger">{{ $message }}</span>
                 @enderror
             </div>

             <div class="col-md-6">
                 <label class="form-label"> أجور التصدير </label>
                 <input type="number" class="form-control" wire:model="approval.send_fee" placeholder="0" disabled
                     readonly />
                 @error('approval.send_fee')
                     <span class="text-danger">{{ $message }}</span>
                 @enderror
             </div>




         </div>


         <br />
         @if ($canCreateExchange)
             <div class="d-grid gap-2 col-6 mx-auto">
                 <button class="btn btn-primary " type="submit" wire:loading.attr="disabled"
                     {{ $send_flag ? '' : 'disabled' }}>ارسال</button>

             </div>
         @else
             <div class="col-md-12 mt-5">
                 <div class="alert alert-danger text-center">
                     {{ $createExchangeMessage ?: 'غير مسموح لك بتنفيذ التحويل حالياً' }}
                 </div>
             </div>
         @endif

         @error('balance')
             <div class="text-center text-danger my-3 fw-bold">

                 {{ $message }}
             </div>
         @enderror
         @error('fee')
             <div class="text-center text-danger my-3 fw-bold">
                 {{ $message }}
             </div>
         @enderror

     </form>
 </div>
