 <div class="col-xl-7 col-lg-7 col-md-6">



     <div class="row select2_content">
         <div class="col-12 pb-4">
             <label class="form-label"> اختصار العمليه </label>

             <x-Mulk.select2 class="  form-control" wire:model.live="exchange_currency">
                 @foreach (getCurrencyShortcuts() as $shortcut)
                     <option value="{{ $shortcut['from_code'] }}_{{ $shortcut['to_code'] }}">
                         {{ $shortcut['from_name'] }} → {{ $shortcut['to_name'] }}
                     </option>
                 @endforeach
             </x-Mulk.select2>

         </div>
     </div>
     <form>



         <div class="row">

             <div class="col-xl-6 col-lg-4 col-md-4">
                 <!-- About User -->
                 <div class="card  mb-4">
                     <div class="card-body">
                         <h4 class="card-text text-uppercase text-center"> عليكم </h4>

                         <div class="row">
                             <div class="col-md-12 mt-3 select2_content">
                                 <label class="form-label"> العملة </label>
                                 <x-Mulk.select2 class="select2 form-select" wire:model="exchange.currency">
                                     @foreach ($currencies as $currency)
                                         <option value="{{ $currency->code }}">{{ $currency->name }}</option>
                                     @endforeach
                                 </x-Mulk.select2>
                                 @error('exchange.currency')
                                     <span class="text-danger">{{ $message }}</span>
                                 @enderror
                             </div>

                             <div class="col-md-12 mt-3">
                                 <label class="form-label" for="amount1">المبلغ <i
                                         class="fas fa-exchange-alt fa-s btn-outline-primary" data-bs-toggle="tooltip"
                                         data-bs-placement="top" data-bs-custom-class="tooltip-primary"
                                         title="تقريب"></i></label>
                                 <input type="number" wire:model.lazy="exchange.amount" class="form-control"
                                     placeholder="100" />
                                 <div class="yellow-box mt-2">
                                     {{ $this->getAmountInWords($exchange['amount'], $exchange['currency']) }}
                                 </div>
                                 @error('exchange.amount')
                                     <span class="text-danger">{{ $message }}</span>
                                 @enderror
                             </div>


                             <div class="col-md-6 mt-3">
                                 <label class="form-label"> السعر </label>
                                 <input type="number" wire:model.live="exchange.rate" class="form-control" disabled
                                     readonly />
                                 @error('exchange.rate')
                                     <span class="text-danger">{{ $message }}</span>
                                 @enderror
                             </div>



                         </div>

                     </div>

                 </div>


             </div>


             <div class="col-xl-6 col-lg-4 col-md-4">
                 <!-- About User -->
                 <div class="card  mb-4">
                     <div class="card-body">
                         <h4 class="card-text text-uppercase text-center"> لكم </h4>

                         <div class="row">
                             <div class="col-md-12 mt-3 select2_content">
                                 <label class="form-label"> العملة </label>
                                 <x-Mulk.select2 class="select2 form-select"
                                     wire:model.live="exchange.delivery_currency" data-allow-clear="true">
                                     @foreach ($currencies as $currency)
                                         <option value="{{ $currency->code }}">{{ $currency->name }}</option>
                                     @endforeach
                                 </x-Mulk.select2>
                             </div>

                             <div class="col-md-12 mt-3">
                                 <label class="form-label" for="amount1">المبلغ <i
                                         class="fas fa-exchange-alt fa-s btn-outline-primary" data-bs-toggle="tooltip"
                                         data-bs-placement="top" data-bs-custom-class="tooltip-primary"
                                         title="تقريب"></i></label>
                                 <input type="number" wire:model.lazy="exchange.delivery_amount" class="form-control"
                                     placeholder="100" />
                                 <div class="yellow-box mt-2">
                                     {{ $this->getAmountInWords($exchange['delivery_amount'], $exchange['delivery_currency']) }}
                                 </div>
                                 @error('exchange.delivery_amount')
                                     <span class="text-danger">{{ $message }}</span>
                                 @enderror
                             </div>

                             <br />
                             @if ($canCreateExchange)
                                 <div class="col-md-12 mt-5">
                                     <button class="btn btn-primary form-control" type="button"
                                         wire:loading.attr="disabled" wire:target="save" wire:click="ConfirmTransfer"
                                         wire:loading.attr="disabled" {{ $send_flag ? '' : 'disabled' }}>تنفيذ</button>
                                 </div>
                             @else
                                 <div class="col-md-12 mt-5">
                                     <div class="alert alert-danger text-center">
                                         {{ $createExchangeMessage ?: 'غير مسموح لك بتنفيذ التحويل حالياً' }}
                                     </div>
                                 </div>
                             @endif



                         </div>

                     </div>

                 </div>


             </div>

         </div>
     </form>

     <style>
         .clickable-strong {
             cursor: pointer;
             transition: transform 0.2s, color 0.2s;
             display: inline-block;
             color: black;
         }

         .clickable-strong:hover {
             color: #007bff;
             /* blue on hover */
             transform: scale(1.1);
             /* slight zoom */
         }
     </style>






 </div>
