 <div class="col-xl-7 col-lg-7 col-md-6">
     <!-- Activity Timeline -->
     <div class="card card-action mb-2">



         <div class="card-body pb-0">




             <div class="col-md-12 select2_content">
                 <label class="form-label">
                     {{ $this->getFieldLabel('recipient.sender_identity_number') ?? __('transfers.sender_national_id') }}:
                 </label>

                 <div class="input-group w-100">

                     <div class="flex-grow-1">
                         <x-Mulk.live_search wire:model="recipient.sender_identity_number" :search-url="$clientsSearchUrl"
                             placeholder="{{ __('transfers.national_id_placeholder') }}" />


                     </div>
                     <button class="btn btn-outline-primary" type="button" x-on:click="$dispatch('AddNewClientEvent')">
                         {{ __('general.add') }}
                     </button>
                 </div>
             </div>

             @if ($add_client)
                 @livewire('client.add')
             @else
                 <div class="row g-2">

                     <div class="col-md-6">
                         <label
                             class="form-label">{{ $this->getFieldLabel('transfer.recipient_name') ?? __('transfers.recipient_name') }}</label>

                         <input type="text" class="form-control" wire:model="transfer.recipient_name"
                             tabindex="{{ $this->getFieldTabIndex('transfer.recipient_name') }}" />
                         @error('recipient.name')
                             <span class="text-danger">{{ $message }}</span>
                         @enderror
                     </div>

                     <div class="col-md-6">
                         <label
                             class="form-label">{{ $this->getFieldLabel('transfer.recipient_phone') ?? __('transfers.recipient_phone') }}</label>
                         <input type="text" class="form-control phone-mask" wire:model="transfer.recipient_phone"
                             tabindex="{{ $this->getFieldTabIndex('transfer.recipient_phone') }}" />
                         @error('recipient.phone')
                             <span class="text-danger">{{ $message }}</span>
                         @enderror
                     </div>

                     {{-- Receiver Agent --}}
                     <div class="col-md-12 select2_content">
                         <label
                             class="form-label">{{ $this->getFieldLabel('transfer.receiver_id') ?? __('transfers.receiver_agent') }}</label>

                         <x-Mulk.ajax-select2 wire:model.live="transfer.receiver_id" searchUrl="/home"
                             placeholder="Select Account"
                             search-url="/Accounts/AgentSearch?type=syp&direction=receiver" />

                         @error('transfer.receiver_id')
                             <span class="text-danger">{{ $message }}</span>
                         @enderror
                     </div>


                     <div class="col-md-6 select2_content">
                         <label
                             class="form-label">{{ $this->getFieldLabel('transfer.currency') ?? __('transfers.sent_currency') }}</label>
                         <x-Mulk.select2 wire:model="transfer.currency" class="form-select"
                             tabindex="{{ $this->getFieldTabIndex('transfer.currency') }}">
                             <option value="">{{ __('general.select') }}</option>
                             @foreach ($currencies as $currency)
                                 <option value="{{ $currency->code }}">{{ $currency->name }}</option>
                             @endforeach
                         </x-Mulk.select2>
                         @error('transfer.currency')
                             <span class="text-danger">{{ $message }}</span>
                         @enderror
                     </div>

                     <div class="col-md-6">
                         <label
                             class="form-label">{{ $this->getFieldLabel('transfer.amount') ?? __('transfers.amount_to_send') }}</label>
                         <x-decimal-input name="amount" model="transfer.amount" placeholder="0.00" required
                             wire:model.lazy="transfer.amount" min="0.01" max="9999.99" />

                         @error('transfer.amount')
                             <span class="text-danger">{{ $message }}</span>
                         @enderror
                     </div>

                     <div class="col-md-6">
                         <label
                             class="form-label">{{ $this->getFieldLabel('transfer.delivery_amount') ?? __('transfers.total_to_receive') }}</label>
                         <x-decimal-input name="delivery_amount" model="transfer.syp_amount" placeholder="0.00" required
                             wire:model.lazy="transfer.syp_amount" min="0.01" max="9999.99" />


                         @error('transfer.delivery_amount')
                             <span class="text-danger">{{ $message }}</span>
                         @enderror
                     </div>
                     <div class="col-md-6">
                         <label
                             class="form-label">{{ $this->getFieldLabel('transfer.exchange_rate') ?? __('transfers.exchange_rate') }}</label>
                         <input type="number" class="form-control" step="0.01" wire:model.lazy="transfer.rate"
                             readonly disabled tabindex="{{ $this->getFieldTabIndex('transfer.exchange_rate') }}" />
                     </div>
                     {{-- Fees --}}
                     <div class="col-md-6">
                         <label
                             class="form-label">{{ $this->getFieldLabel('transfer.send_fee') ?? __('transfers.transfer_fee') }}</label>
                         <x-decimal-input name="send_fee" model="transfer.send_fee" placeholder="0.00" required
                             wire:model.live="transfer.send_fee" min="0.01" max="9999.99" disabled readonly
                             tabindex="{{ $this->getFieldTabIndex('transfer.send_fee') }}" />


                         @error('transfer.send_fee')
                             <span class="text-danger">{{ $message }}</span>
                         @enderror
                     </div>



                     {{-- Fee Type --}}
                     <div class="col-md-6">
                         <label
                             class="form-label">{{ $this->getFieldLabel('transfer.fee_type') ?? __('transfers.fee_type') }}</label>
                         <select class="form-select" wire:model="transfer.fee_type"
                             tabindex="{{ $this->getFieldTabIndex('transfer.fee_type') }}">
                             <option value="collected">{{ __('transfers.fee_collected') }}</option>
                             <option value="included">{{ __('transfers.fee_included') }}</option>
                         </select>
                     </div>



                     @if ($this->fieldIsVisible('transfer.reason_id'))
                         <div class="col-md-6  select2_content">
                             <label
                                 class="form-label">{{ $this->getFieldLabel('transfer.reason_id') ?? __('transfers.transfer_reason') }}</label>
                             <x-Mulk.select2 class="form-select" wire:model="transfer.reason_id"
                                 tabindex="{{ $this->getFieldTabIndex('transfer.reason_id') }}">
                                 @foreach ($reasons as $reason)
                                     <option value="{{ $reason->id }}">{{ $reason->name }}</option>
                                 @endforeach
                             </x-Mulk.select2>
                         </div>
                     @endif
                     {{-- Notes --}}
                     @if ($this->fieldIsVisible('transfer.notes'))
                         <div class="col-md-6">
                             <label
                                 class="form-label">{{ $this->getFieldLabel('transfer.notes') ?? __('transfers.notes') }}</label>
                             <input type="text" class="form-control" placeholder="ملاحظات"
                                 wire:model="transfer.notes"
                                 tabindex="{{ $this->getFieldTabIndex('transfer.notes') }}" />
                         </div>
                     @endif
                     <div class="col-md-12">
                         <label class="form-label">{{ __('transfers.address') }}</label>
                         <textarea class="form-control" readonly disabled>{{ $address }} </textarea>
                     </div>

                 </div>

                 @livewire('components.attachments-repeater')

                 <br />
                 <div class="d-grid gap-2 col-6 mx-auto">
                     <button class="btn btn-primary" type="button" wire:click="confirmTransfer"
                         wire:loading.attr="disabled" {{ $send_flag ? '' : 'disabled' }}>
                         <i class="ti ti-send"></i> {{ __('transfers.send') }}
                     </button>
                 </div>

                 @if (!$errors->has('balance') && !$errors->has('fee'))
                     <div class=" success  text-center mt-2" style="color: green;font-weight: bold">
                         @if ($transfer['amount'] > 0)
                             إرسال مبلغ {{ $this->getAmountInWords($transfer['amount'], $transfer['currency']) }}
                         @endif
                     </div>
                 @endif
                 @error('balance')
                     <div class="text-center text-danger my-3 fw-bold">

                         {{ $message }}
                     </div>
                 @enderror
                 @error('fee')
                     <div class="text-center text-danger my-3 fw-bold">
                         {{ $message }}
                     </div>
                 @enderror


             @endif
         </div>
     </div>
     <!--/ Activity Timeline -->
 </div>
