<table class="table table-sm table-bordered mb-0">
    <thead>
        <tr>
            <th>العملة</th>
            <th>تفعيل</th>
            <th>سعر المبيع</th>
            <th>سعر الشراء</th>
            <th>سعر الشراء النهائي</th> <!-- new column -->
        </tr>
    </thead>
    <tbody>
        @foreach ($currencies as $currency)
            <tr>

                <td>{{ $currency->code }}</td>
                <td class="text-center">
                    <label class="switch">
                        <input type="checkbox" class="switch-input"
                            wire:model.live="rates.{{ $agent->id }}.{{ $currency->code }}.enabled">
                        <span class="switch-toggle-slider">
                            <span class="switch-on">on</span>
                            <span class="switch-off">off</span>
                        </span>
                    </label>

                </td>
                <td>
                    <input type="number" class="form-control form-control-sm"
                        wire:model.lazy="rates.{{ $agent->id }}.{{ $currency->code }}.sell">
                </td>
                <td>
                    <div class="input-group input-group-sm">
                        <!-- Mode Selector -->
                        <select class="form-select form-select-sm"
                            wire:model.lazy="rates.{{ $agent->id }}.{{ $currency->code }}.buy_mode">
                            <option value="actual">Actual</option>
                            <option value="difference">Difference</option>
                        </select>

                        <!-- Input -->
                        <input type="text" class="form-control"
                            wire:model.lazy="rates.{{ $agent->id }}.{{ $currency->code }}.buy_input"
                            placeholder="Buy Price">

                        <span class="input-group-text">SYP</span>
                    </div>
                </td>
                <td>
                    @php
                        $rate = $rates[$agent->id][$currency->code] ?? null;
                        $finalBuy = 0;
                        if ($rate) {
                            if (($rate['buy_mode'] ?? '') === 'difference') {
                                $finalBuy = ($rate['sell'] ?? 0) + ($rate['buy_input'] ?? 0);
                            } else {
                                $finalBuy = $rate['buy_input'] ?? 0;
                            }
                        }
                    @endphp
                    <strong>{{ number_format($finalBuy, 2) }} SYP</strong>
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
