<div>
    <div class="modal fade" id="AddNewBranchModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-xl modal-simple" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <div class="text-center mb-4">
                        <h4 class="mb-2">
                            {{ $action_type == 'edit' ? __('agents.edit_branchss') : __('agents.add_new_branch') }}
                    </div>
                    <form class="row g-6">
                        <!-- Branch Name -->
                        <div class="col-12 col-md-6">
                            <label class="form-label">{{ __('agents.branch_name') }} <span
                                    class="text-danger">*</span></label>
                            <input type="text" wire:model.defer="branch.name" class="form-control" />
                            @error('branch.name')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- Parent Agent Selector -->
                        <div class="col-12 col-md-6 select2_content">
                            <label class="form-label">{{ __('agents.parent_agent') }} <span
                                    class="text-danger">*</span></label>
                            <x-Mulk.select2 class="form-select" wire:model.defer="branch.parent_id">
                                <option value="">{{ __('general.select') }}</option>
                                @foreach ($agents as $agent)
                                    <option value="{{ $agent->id }}">{{ $agent->name }}</option>
                                @endforeach
                            </x-Mulk.select2>
                            @error('branch.parent_id')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- Phone -->
                        <div class="col-12 col-md-6">
                            <label class="form-label">{{ __('agents.phone') }} <span
                                    class="text-danger">*</span></label>
                            <input type="text" wire:model.defer="branch.phone" class="form-control" />
                            @error('branch.phone')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- Country -->
                        <div class="col-12 col-md-6 select2_content">
                            <label class="form-label">{{ __('address.country') }} <span
                                    class="text-danger">*</span></label>
                            <x-Mulk.select2 wire:model="address.country" class="select2 form-select">
                                <option value="">{{ __('actions.select') }}</option>
                                @foreach ($countries as $key => $value)
                                    <option value="{{ $key }}">{{ $value }}</option>
                                @endforeach
                            </x-Mulk.select2>
                            @error('address.country')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- City -->
                        <div class="col-12 col-md-6">
                            <label class="form-label">{{ __('address.city') }} <span
                                    class="text-danger">*</span></label>
                            <input type="text" wire:model.defer="address.city" class="form-control" />
                            @error('address.city')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- State / Neighborhood / District -->
                        <div class="col-md-6">
                            <label class="form-label">المنطقة</label>
                            <input type="text" class="form-control" wire:model.defer="address.state" />
                            @error('address.state')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">الحي</label>
                            <input type="text" class="form-control" wire:model.defer="address.neighborhood" />
                            @error('address.neighborhood')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">الشارع</label>
                            <input type="text" class="form-control" wire:model.defer="address.district" />
                            @error('address.district')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- Full Address -->
                        <div class="col-12 col-md-6">
                            <label class="form-label">{{ __('address.address') }}</label> <span class="text-danger">*</span>
                            <input type="text" wire:model.defer="address.full_address" class="form-control" />
                            @error('address.full_address')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- Buttons -->
                        <div class="col-12 text-center">
                            <button type="button" class="btn btn-primary me-3"
                                wire:click="Save">{{ __('actions.save') }}</button>
                            <button type="reset" class="btn btn-label-secondary"
                                data-bs-dismiss="modal">{{ __('actions.cancel') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
