<div>
    <!-- Page Header -->
    <h4 class="fw-bold py-3 mb-4">ال APIS المتوفرة</h4>

    <!-- Available APIs -->
    <div class="row">
        @foreach ($apiTypes as $api)
            <div class="col-md-6 col-lg-4 mb-4">
                <div class="card h-100">
                    <div class="card-body d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="card-title mb-1">{{ $api->name }}</h5>
                        </div>
                        <button wire:click="openModal({{ $api->id }})" class="btn btn-primary btn-sm">
                            <i class="bx bx-cog me-1"></i> اعداد
                        </button>
                    </div>
                </div>
            </div>
        @endforeach
    </div>

    <!-- Modal -->
    <div wire:ignore.self class="modal fade" id="APIConfigModal" tabindex="-1" aria-labelledby="APIConfigModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-0 shadow">
                <div class="modal-header">
                    <h5 class="modal-title">إعداد API</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-body">
                    <form wire:submit.prevent="save" class="row g-4">
                        <div class="col-6">
                            <label class="form-label">{{ __('general.name') }}</label>
                            <input type="text" wire:model.lazy="name" class="form-control" />
                            @error('name')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                        <!-- Agent Dropdown -->
                        <div class="col-6">
                            <label class="form-label"> {{ __('general.agent') }}</label>
                            <select wire:model.lazy="agentId" class="form-select">
                                <option value="">{{ __('general.select') }}</option>
                                @foreach ($agents as $agent)
                                    <option value="{{ $agent->id }}">{{ $agent->name }}</option>
                                @endforeach
                            </select>
                            @error('agentId')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>

                        <!-- Dynamic Fields -->
                        @foreach ($formFields as $field)
                            <div class="col-md-6">
                                <label class="form-label">{{ ucfirst($field) }}</label>
                                <input type="text" wire:model.lazy="formData.{{ $field }}"
                                    class="form-control">
                                @error("formData.$field")
                                    <small class="text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        @endforeach
                        @if (count($externalAgents))
                            <hr>
                            <h6>{{ __('general.external_agents') }}</h6>
                            <div style="max-height: 200px; overflow-y: auto;" class="border rounded p-2">
                                <ul class="list-group list-group-flush">
                                    @foreach ($externalAgents as $agent)
                                        @php
                                            $agentId = $agent['id'];
                                            $agentName = $agent['text'] ?? $agent['name'];
                                            $isSelected = in_array($agentId, $selectedAgents);

                                        @endphp

                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                            <div>
                                                <strong>{{ $agentName }}</strong>
                                                <small class="text-muted d-block">ID: {{ $agentId }}</small>
                                            </div>
                                            <div class="form-check form-switch">
                                                <input type="checkbox"
                                                    wire:change="toggleExternalAgent('{{ $agentId }}')"
                                                    class="form-check-input" id="toggle_{{ $agentId }}"
                                                    {{ $isSelected ? 'checked' : '' }}>
                                            </div>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <div class="col-md-6">
                            <label class="form-label">{{ __('general.file_upload') }}</label>
                            <input type="file" wire:model="avatar" class="form-control">
                            @error('file')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                            @if ($avatar)
                                {{-- Editing existing config: show stored logo --}}
                                <img src="{{ $avatar->getUrl() }}" class="img-fluid rounded shadow-sm mt-2"
                                    style="max-width: 150px; max-height: 150px; object-fit: contain;">
                                <small class="text-muted d-block mt-1">📂 Existing Logo</small>
                            @endif
                        </div>

                        <div class="col-12 text-end">
                            <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                                <i class="bx bx-save me-1"></i> {{ __('actions.save') }}
                            </button>
                            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                                {{ __('actions.cancel') }}
                            </button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Configured APIs Table -->
    <div class="card mt-5">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Configured APIs</h5>
        </div>
        <div class="table-responsive text-nowrap">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>{{ __('general.agent') }}</th>
                        <th>{{ __('general.api_type') }}</th>
                        <th>Base URL</th>
                        <th>{{ __('actions.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($configs as $config)
                        <tr>
                            <td>{{ $config->agent->name }}</td>
                            <td>{{ $config->apiType->name }}</td>
                            <td class="text-muted small">{{ $config->base_url }}</td>
                            <td class="d-flex gap-2">
                                <button wire:click="editConfig({{ $config->id }})" class="btn btn-sm btn-primary">
                                    <i class="ti ti-edit"></i>
                                </button>
                                <button wire:click="deleteConfig({{ $config->id }})" class="btn btn-sm btn-danger">
                                    <i class="ti ti-trash"></i>
                                </button>
                                <button wire:click="testConnection({{ $config->id }})"
                                    class="btn btn-sm btn-secondary">
                                    <i class="ti ti-plug"></i>
                                </button>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="text-center text-muted">No API configurations found.</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
