<div>

    <div class="modal fade" id="AddNewApprovalModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-lg   " wire:ignore.self>
            <div class="modal-content">
                <div class="modal-body">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <div class="text-center mb-6">
                        <h4 class="address-title mb-2">{{ __('transfers.add_new_approval') }}</h4>

                    </div>
                    <form class="card-body" wire:submit.prevent="sendConfirm">

                        <div class="row g-3">


                            <div class="col-md-12">
                                <label class="form-label"> الشركة </label>
                                <select class="select2 form-select" data-allow-clear="true" wire:model.live="company">

                                    @foreach ($companies as $key => $value)
                                        <option value="{{ $value }}">{{ $key }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="mb-3  ">

                                <div class="dropdown">
                                    <i class="ti ti-tag cursor-pointer" id="dropdownLabel1" data-bs-toggle="dropdown"
                                        aria-haspopup="true" aria-expanded="false" style="color :red;"></i>
                                    <div class="dropdown-menu dropdown-menu-start" aria-labelledby="dropdownLabel1"
                                        style="padding: 20px;">
                                        <x-balance-badges :balances="$this->getBalances($approval['sender_id'])" :limit="2000" :basebalance="getBaseCurrencyBalance($this->getBalances($approval['sender_id']))"
                                            basecurrency="USD" />
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12 select2_content">
                                <label class="form-label"> المصدر </label>
                                <x-Mulk.select2 class="select2 form-select" wire:model.live='approval.sender_id'>
                                    <option value="">{{ __('general.select') }}</option>
                                    @foreach ($agents as $agent)
                                        <option value="{{ $agent->id }}">{{ $agent->name }}</option>
                                    @endforeach

                                </x-Mulk.select2>
                                @error('approval.sender_id')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>







                            <div class="col-md-6 select2_content">
                                <label class="form-label"> العملة </label>
                                <x-Mulk.select2 class="select2 form-select" wire:model.live="approval.currency"
                                    data-allow-clear="true">
                                    <option value="">{{ __('general.select') }}</option>
                                    @foreach ($currencies as $currency)
                                        <option value="{{ $currency->code }}">{{ $currency->name }}</option>
                                    @endforeach
                                </x-Mulk.select2>
                                @error('approval.currency')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label"> المبلغ </label>
                                <input type="number" class="form-control" placeholder="100"
                                    wire:model="approval.amount" />
                                @error('approval.amount')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>


                            <div class="col-md-12 select2_content">
                                <label class="form-label"> الصندوق </label>
                                <x-Mulk.live_search wire:model="approval.receiver_account_code" :search-url="$url"
                                    placeholder="Select Account" />

                                <div class="yellow-box mt-2">
                                    {{ $this->receiver->name ?? '' }}
                                </div>

                                @error('approval.receiver_id')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror

                                @error('approval.receiver_account_code')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>












                            <div class="col-md-12">
                                <label class="form-label"> ملاحظات </label>
                                <textarea class="form-control" placeholder="ملاحظات" wire:model="approval.notes"></textarea>
                                @error('approval.notes')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="col-md-6">
                                <label class="form-label"> أجور التصدير </label>
                                <input type="number" class="form-control" wire:model="approval.send_fee"
                                    placeholder="00000" />
                                @error('approval.send_fee')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>




                        </div>


                        <br />
                        @if ($canCreateExchange)
                            <div class="d-grid gap-2 col-6 mx-auto">
                                <button class="btn btn-primary " type="submit"
                                    wire:loading.attr="disabled">ارسال</button>

                            </div>
                        @else
                            <div class="col-md-12 mt-5">
                                <div class="alert alert-danger text-center">
                                    {{ $createExchangeMessage ?: 'غير مسموح لك بتنفيذ التحويل حالياً' }}
                                </div>
                            </div>
                        @endif


                        @error('balance')
                            <div class="text-center text-danger my-3 fw-bold">

                                {{ $message }}
                            </div>
                        @enderror
                        @error('fee')
                            <div class="text-center text-danger my-3 fw-bold">

                                {{ $message }}
                            </div>
                        @enderror

                    </form>
                </div>
            </div>
        </div>
    </div>

</div>
