<div>
    @if ($showModal && $audit)
        <div class="modal fade show" style="display: block;" tabindex="-1">
            <div class="modal-dialog modal-xl modal-simple">
                <div class="modal-content">
                    <div class="modal-body">
                        <button type="button" class="btn-close" wire:click="closeModal" aria-label="Close"></button>
                        <div class="text-center mb-6">
                            <h4 class="address-title mb-2">Audits</h4>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="card pt-0">
                                    <div class="card-header">
                                        <h4 class="card-mb-2">
                                            <i class="fas fa-history"></i> Activity Logs
                                        </h4>
                                    </div>

                                    <!-- Activity Timeline -->
                                    <div class="card-body pb-0">
                                        <ul class="timeline mb-0">
                                            <li class="timeline-item timeline-item-transparent">
                                                <span class="timeline-point timeline-point-primary"></span>
                                                <div class="timeline-event">
                                                    <div class="timeline-header mb-1">
                                                        <h6 class="mb-0">
                                                            {{ $audit->created_at }}
                                                            ({{ $audit->created_at->diffForHumans() }})
                                                            @lang('audit.' . $audit->event . '.metadata', $audit->getMetadata())
                                                        </h6>
                                                        <h6 class="mb-0">
                                                            @lang('audit.' . $audit->event . '.device_type', $audit->getMetadata())
                                                            @lang('audit.' . $audit->event . '.platform', $audit->getMetadata())
                                                            @lang('audit.' . $audit->event . '.browser', $audit->getMetadata())
                                                        </h6>

                                                        <div>
                                                            <strong style='color:blue' title="@lang('audit.' . $audit->event . '.isp', $audit->getMetadata())">
                                                                @lang('audit.' . $audit->event . '.ip', $audit->getMetadata())
                                                            </strong>

                                                            {!! Lang::get('audit.' . $audit->event . '.country', $audit->getMetadata()) !!}
                                                        </div>
                                                    </div>

                                                    <ul class="timeline">
                                                        @foreach ($audit->getModified() as $attribute => $modified)
                                                            @if (Lang::has('audit.' . $audit->event . '.modified.' . $attribute))
                                                                <li>@lang('audit.' . $audit->event . '.modified.' . $attribute, $modified)</li>
                                                            @endif
                                                        @endforeach
                                                    </ul>
                                                </div>
                                            </li>
                                        </ul>

                                        <div class="d-flex justify-content-center mt-3">
                                        </div>
                                    </div>
                                    <!-- /Activity Timeline -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal Backdrop -->
        <div class="modal-backdrop fade show"></div>
    @endif
</div>
