<div class="account-search-component">
    <!-- Search Form -->
    <div class="card border-0 shadow-sm">
        <div class="card-body p-3">
            <div class="input-group">
                <input type="text" class="form-control @error('searchAccount') is-invalid @enderror"
                    placeholder="{{ __('Enter account code...') }}" wire:model="searchAccount"
                    wire:keydown.enter="performSearch">
                <button class="btn btn-primary" type="button" wire:click="performSearch">
                    <i class="tf-icons ti ti-search"></i>
                </button>
                @if ($searchAccount)
                    <button class="btn btn-outline-secondary" type="button" wire:click="clearSearch">
                        <i class="tf-icons ti ti-x"></i>
                    </button>
                @endif
            </div>

            @error('searchAccount')
                <div class="invalid-feedback d-block mt-2">
                    {{ $message }}
                </div>
            @enderror

            <!-- Error Message -->
            @if ($errorMessage)
                <div class="alert alert-danger mt-3" role="alert">
                    <i class="tf-icons ti ti-alert-circle me-2"></i>
                    {{ $errorMessage }}
                </div>
            @endif

            <!-- Search Results -->
            @if ($showResults && $account)
                <div class="mt-3">
                    <div class="alert alert-success border-success">
                        <div class="d-flex align-items-center mb-2">
                            <i class="tf-icons ti ti-check-circle me-2"></i>
                            <strong>{{ __('Account Found') }}</strong>
                        </div>
                        <div class="row g-2">
                            <div class="col-md-6">
                                <label class="form-label text-muted small">{{ __('Account Code') }}</label>
                                <div class="fw-bold text-dark">{{ $account->code ?? __('N/A') }}</div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label text-muted small">{{ __('Account Name') }}</label>
                                <div class="fw-bold text-dark">{{ $this->getAccountName($account) }}</div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label text-muted small">{{ __('Status') }}</label>
                                <div>
                                    @php
                                        $status = $account->status ?? 'active';
                                        $statusClass = match ($status) {
                                            'active' => 'success',
                                            'inactive' => 'warning',
                                            'suspended' => 'danger',
                                            'pending' => 'info',
                                            default => 'secondary',
                                        };
                                    @endphp
                                    <span class="badge bg-{{ $statusClass }}">
                                        {{ __($status) }}
                                    </span>
                                </div>
                            </div>
                        </div>

                        <!-- Account Balances -->
                        <div class="mt-3">
                            <label class="form-label text-muted small mb-3">{{ __('Account Balances') }}</label>
                            <div class="row g-2">
                                @php
                                    $balances = $this->getBalances($account->code);
                                    $balanceLimit = $this->getBalanceLimit($account->code);
                                @endphp
                                @if ($balances && $balances->count() > 0)
                                    @foreach ($balances as $balance)
                                        <div class="col-6">
                                            <div
                                                class="card border-0 bg-light-{{ $balance['balance'] >= 0 ? 'success' : 'danger' }}">
                                                <div class="card-body p-2">
                                                    <div class="d-flex align-items-center">
                                                        <div class="flex-shrink-0">
                                                            <div class="avatar avatar-sm">
                                                                <span
                                                                    class="avatar-initial rounded bg-{{ $balance['balance'] >= 0 ? 'danger' : 'success' }}">
                                                                    <i
                                                                        class="ti ti-{{ $balance['balance'] >= 0 ? 'trending-down' : 'trending-up' }}"></i>
                                                                </span>
                                                            </div>
                                                        </div>
                                                        <div class="flex-grow-1 ms-2">
                                                            <h6 class="mb-0 fw-semibold text-dark">
                                                                {{ number_format(abs($balance['balance']), 2) }}</h6>
                                                            <small class="text-muted">
                                                                {{ $this->getCurrencyName($balance['currency']) }} -
                                                                <span
                                                                    class="text-{{ $balance['balance'] >= 0 ? 'danger' : 'success' }} fw-bold">
                                                                    {{ $balance['balance'] >= 0 ? __('علينا') : __('لنا') }}
                                                                </span>
                                                            </small>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @else
                                    <div class="col-12">
                                        <div class="alert alert-info border-info">
                                            <i class="ti ti-info-circle me-2"></i>
                                            {{ __('No balances found for this account.') }}
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>


                    </div>
                </div>
            @elseif ($showResults && !$account)
                <div class="mt-3">
                    <div class="alert alert-warning border-warning">
                        <div class="d-flex align-items-center">
                            <i class="tf-icons ti ti-alert-triangle me-2"></i>
                            <strong>{{ __('No Account Found') }}</strong>
                        </div>
                        <p class="mb-0 mt-2">{{ __('No account found with the provided search term.') }}</p>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>
