<div>
    <div class="d-none">
        <pre>@json($attachments, JSON_PRETTY_PRINT)</pre>
    </div>
    @foreach ($attachments as $index => $attachment)
        <div class="row mb-3 align-items-end" wire:key="attachment-{{ $index }}-{{ $componentId }}">
            <div class="col-md-2">
                <label class="form-label">Input Method</label>
                <select class="form-select form-select-sm" wire:model="attachments.{{ $index }}.mode"
                    name="attachments.{{ $index }}.mode" wire:change="updateMode({{ $index }})">
                    <option value="upload">Upload File</option>
                    <option value="camera">Take Photo</option>
                </select>
            </div>

            <div class="col-md-5">
                <label class="form-label">File</label>

                @if (($attachments[$index]['mode'] ?? 'upload') === 'camera')
                    <div wire:ignore x-data="cameraHandler({{ $index }}, '{{ $componentId }}')" x-init="initCamera()" class="camera-container">

                        <!-- Camera Preview with Frame -->
                        <div class="camera-preview-frame mb-2">
                            <video x-ref="videoElement" class="camera-view" x-show="!photoTaken" autoplay
                                playsinline></video>
                            <div class="camera-overlay" x-show="!photoTaken" @click="capturePhoto">
                                <i class="fas fa-camera"></i>
                                <span>Click to capture</span>
                            </div>
                            <img x-ref="previewElement" class="camera-preview" x-show="photoTaken" />
                        </div>

                        <!-- Action Buttons -->
                        <div class="d-flex gap-2">
                            <button type="button" class="btn btn-sm btn-primary flex-grow-1" @click="capturePhoto"
                                x-show="!photoTaken">
                                <i class="fas fa-camera me-1"></i> Capture
                            </button>

                            <button type="button" class="btn btn-sm btn-outline-danger flex-grow-1"
                                @click="retakePhoto" x-show="photoTaken">
                                <i class="fas fa-redo me-1"></i> Retake
                            </button>
                        </div>

                        <canvas x-ref="canvasElement" class="d-none"></canvas>
                    </div>
                @else
                    <input type="file" class="form-control form-control-sm"
                        wire:model="attachments.{{ $index }}.file">
                @endif

                @error("attachments.$index.file")
                    <span class="text-danger small">{{ $message }}</span>
                @enderror
            </div>

            <div class="col-md-3">
                <label class="form-label">Attachment Type</label>
                <select class="form-select form-select-sm" wire:model="attachments.{{ $index }}.type">
                    <option value="">-- Select Type --</option>
                    <option value="id_card">ID Card</option>
                    <option value="passport">Passport</option>
                    <option value="other">Other</option>
                </select>
                @error("attachments.$index.type")
                    <span class="text-danger small">{{ $message }}</span>
                @enderror
            </div>

            <div class="col-md-2">
                @if ($index > 0)
                    <button type="button" class="btn btn-outline-danger btn-sm"
                        wire:click.prevent="removeAttachment({{ $index }})">
                        <i class="fa fa-trash"></i>
                    </button>
                @endif
            </div>
        </div>
    @endforeach

    <button type="button" class="btn btn-outline-primary btn-sm mt-2" wire:click="addAttachment">
        <i class="fa fa-plus"></i> Add Attachment
    </button>
    <style>
        .camera-container {
            max-width: 100%;
        }

        .camera-preview-frame {
            position: relative;
            width: 100%;
            aspect-ratio: 4/3;
            background: #f8f9fa;
            border-radius: 8px;
            overflow: hidden;
            cursor: pointer;
            border: 2px dashed #dee2e6;
            transition: all 0.3s ease;
        }

        .camera-preview-frame:hover {
            border-color: #0d6efd;
        }

        .camera-view,
        .camera-preview {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .camera-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            color: #6c757d;
            background: rgba(248, 249, 250, 0.7);
        }

        .camera-overlay i {
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }
    </style>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('cameraHandler', (index, componentId) => ({
                index: index,
                componentId: componentId,
                photoTaken: false,
                stream: null,

                initCamera() {
                    const video = this.$refs.videoElement;

                    // Stop any existing stream
                    if (this.stream) {
                        this.stream.getTracks().forEach(track => track.stop());
                        this.stream = null;
                    }

                    // Clear video source
                    video.srcObject = null;

                    // Use front-facing camera if available on mobile
                    const constraints = {
                        video: {
                            facingMode: 'environment',
                            width: {
                                ideal: 1280
                            },
                            height: {
                                ideal: 720
                            }
                        }
                    };

                    navigator.mediaDevices.getUserMedia(constraints)
                        .then(stream => {
                            this.stream = stream;
                            video.srcObject = stream;
                            video.play();
                        })
                        .catch(e => {
                            console.error('Camera error:', e);
                            // Fallback to default camera if environment mode fails
                            navigator.mediaDevices.getUserMedia({
                                    video: true
                                })
                                .then(stream => {
                                    this.stream = stream;
                                    video.srcObject = stream;
                                    video.play();
                                })
                                .catch(e => {
                                    alert('Failed to access camera: ' + e.message);
                                });
                        });
                },

                capturePhoto() {
                    const video = this.$refs.videoElement;
                    const canvas = this.$refs.canvasElement;
                    const preview = this.$refs.previewElement;

                    canvas.width = video.videoWidth;
                    canvas.height = video.videoHeight;
                    const context = canvas.getContext('2d');
                    context.drawImage(video, 0, 0, canvas.width, canvas.height);
                    const imageData = canvas.toDataURL('image/jpeg', 0.8);

                    preview.src = imageData;
                    this.photoTaken = true;

                    if (this.stream) {
                        this.stream.getTracks().forEach(track => track.stop());
                        this.stream = null;
                    }
                    const componentEl = this.$el.closest('[wire\\:id]');
                    if (!componentEl) {
                        console.error('Livewire component element not found');
                        return;
                    }

                    const livewireId = componentEl.getAttribute('wire:id');
                    const livewireComponent = Livewire.find(livewireId);

                    if (!livewireComponent) {
                        console.error('Livewire component not found for ID:', livewireId);
                        return;
                    }
                    // Call Livewire method instead of directly setting property
                    livewireComponent.call('setCameraPhoto', this.index, imageData);
                },

                retakePhoto() {
                    this.photoTaken = false;
                    this.$refs.previewElement.src = '';
                    Livewire.find(this.componentId).set(`attachments.${this.index}.file`, null);
                    this.initCamera();
                }
            }));
        });
    </script>
</div>
