<div>
    <div wire:ignore.self class="modal fade" id="collectionModal" tabindex="-1" aria-labelledby="collectionModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header  text-white">
                    <h5 class="modal-title" id="collectionModalLabel">{{ $modal_title }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <form>
                    <div class="modal-body" style="max-height: 80vh; overflow-y: auto;">

                        {{-- Account Title Section --}}
                        <div class="card mb-3">
                            <div class="card-header">
                                <h6 class="mb-0">Account Title</h6>
                            </div>
                            <div class="card-body">

                                <div class="row mb-2">

                                    <div class="col-md-4 select2_content">

                                        <x-Mulk.select2 wire:model.defer="tenant_id" class="form-select">
                                            <option value="">Select Cari</option>
                                            @foreach ($tenants as $tenant)
                                                <option value="{{ $tenant->id }}">{{ $tenant->name }}

                                                </option>
                                            @endforeach
                                        </x-Mulk.select2>
                                    </div>


                                    <div class="col-md-4">
                                        <input type="text" class="form-control" placeholder="Hesap Ara.."
                                            wire:model.live="search_account" />
                                    </div>
                                    <div class="col-md-4 d-flex justify-content-end align-items-center gap-3">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox"
                                                wire:model.live="showmainaccount" id="showmainaccount">
                                            <label class="form-check-label" for="showmainaccount">Show Main
                                                Account</label>
                                        </div>

                                    </div>
                                </div>

                                <div class="table-responsive">
                                    <table class="table table-hover table-sm table-borderless">
                                        <thead>
                                            <tr>
                                                <th>Portföy</th>
                                                <th>Cari Kodu</th>
                                                <th>Tür</th>
                                                <th>Bakiye</th>
                                                <th>Döviz Cinsi</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($accounts as $account)
                                                <tr>
                                                    <td>
                                                        <div class="form-check">
                                                            <input type="radio" class="form-check-input"
                                                                id="account_{{ $account['id'] }}" name="radioAccount"
                                                                wire:model.live="selected_account"
                                                                value="{{ $account['id'] }}">
                                                            <label class="form-check-label"
                                                                for="account_{{ $account['id'] }}">
                                                                {{ $contract->portfolio->name ?? '' }}</label>
                                                        </div>
                                                    </td>
                                                    <td>{{ $account['cari_code'] }}</td>
                                                    <td>{{ $account['name'] }}</td>
                                                    <td class="{{ FormatBalanceColor($account['balance']) }} fw-bold">
                                                        {{ number_format($account['balance'], 2) }}</td>
                                                    <td>{{ $account['currency'] }}</td>
                                                    <td><a href="javascript:void(0)" title="View Transactions"
                                                            wire:click="showWalletTransactions({{ $account['id'] }})"><i
                                                                class="fa fa-eye"></i></a></td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                            </div>
                        </div>

                        {{-- Collection Info Section --}}
                        <div class="card">
                            <div class="card-header">
                                <h6 class="mb-0">Collection Information</h6>
                            </div>
                            <div class="card-body">

                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        <label for="price" class="form-label">Amount</label>
                                        <div class="input-group">
                                            <input type="number" min="0" wire:model.live="amount"
                                                class="form-control" placeholder="0,00">
                                            <select class="form-select" wire:model.defer="currency">
                                                <option value="TRY">TRY</option>
                                                <option value="USD">USD</option>
                                                <option value="EUR">EUR</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-4 select2_content">
                                        <label for="bank" class="form-label">Bank / Safe</label>
                                        <x-Mulk.select2 wire:model.defer="bank" placeholder="Select Bank / Safe"
                                            class="form-select">
                                            <option value="">Select Bank / Safe</option>
                                            @foreach ($banks as $bank)
                                                <option value="{{ $bank->id }}">{{ $bank->name }}
                                                    ({{ PriceFormat($bank->balance) }})
                                                </option>
                                            @endforeach
                                        </x-Mulk.select2>
                                        @error('bank')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="col-md-4">
                                        <label for="date" class="form-label">Date</label>
                                        <x-Mulk.date wire:model.defer="collection_date" :key="'collection_date'" />
                                    </div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-md-6 d-flex align-items-center gap-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio"
                                                wire:model.defer="collectionType" value="Collection">
                                            <label class="form-check-label">Collection</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio"
                                                wire:model.defer="collectionType" value="Check">
                                            <label class="form-check-label">Check</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="radio"
                                                wire:model.defer="collectionType" value="Bill">
                                            <label class="form-check-label">Bill</label>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <label for="receipt" class="form-label">Receipt</label>
                                        <input type="file" class="form-control" wire:model="receipt">
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea class="form-control" wire:model.defer="description" rows="2"></textarea>
                                </div>

                            </div>
                        </div>

                        <div class="card p-4 rounded-xl shadow-md bg-white">
                            <div class="grid grid-cols-6 gap-4 font-semibold text-gray-600 border-b pb-2 mb-2">
                                <div>Fatura Tipi</div>
                                <div>Vade Tarihi</div>
                                <div>Borç</div>
                                <div>Gecikme</div>
                                <div>Ödeme</div>
                                <div>Kalan</div>
                            </div>

                            @foreach ($invoices as $index => $invoice)
                                <div class="grid grid-cols-6 gap-4 items-center mb-2 border-b py-2">
                                    {{-- Type & Description --}}
                                    <div>
                                        <span
                                            class="text-sm font-semibold text-purple-700">{{ $invoice['type'] }}</span><br>
                                        @if ($invoice['description'])
                                            <span class="text-xs text-gray-500">{{ $invoice['description'] }}</span>
                                        @endif
                                    </div>

                                    {{-- Due Date --}}
                                    <div class="{{ $invoice['due_date'] ? 'text-pink-600 font-semibold' : '' }}">
                                        {{ $invoice['due_date'] ? \Carbon\Carbon::parse($invoice['due_date'])->format('d.m.Y') : '' }}
                                    </div>

                                    {{-- Debt --}}
                                    <div class="flex items-center gap-1">
                                        <input type="number" wire:model.live="invoices.{{ $index }}.debt"
                                            class="form-control bg-gray-100 text-right" disabled>
                                        <span class="text-sm">TRY</span>
                                    </div>

                                    {{-- Delay Fee --}}
                                    <div class="flex items-center gap-1">
                                        <input type="number"
                                            wire:model.live="invoices.{{ $index }}.delay_fee"
                                            class="form-control w-full text-right">
                                        @if ($invoice['delay_fee'])
                                            <button wire:click="removeDelay({{ $index }})"
                                                class="text-pink-500">
                                                <i class="ti ti-trash"></i>
                                            </button>
                                        @endif
                                        <span class="text-sm">TRY</span>
                                        <i class="ti ti-info-circle text-emerald-500"></i>
                                    </div>

                                    {{-- Payment --}}
                                    <div class="flex items-center gap-1">
                                        <input type="number" wire:model.live="invoices.{{ $index }}.payment"
                                            class="form-control w-full text-right">
                                        <span class="text-sm">TRY</span>

                                    </div>

                                    {{-- Remaining --}}
                                    <div class="flex items-center gap-2">
                                        <input type="number"
                                            wire:model.defer="invoices.{{ $index }}.remaining_amount"
                                            class="form-control w-full text-right" disabled>
                                        <span class="text-sm">TRY</span>

                                    </div>
                                </div>
                            @endforeach
                            @if ($extraPayment > 0)
                                <div class="grid grid-cols-6 gap-4 items-center mb-2 border-b py-2">
                                    <div><span class="bg-purple-100 text-purple-700 px-2 py-1 rounded text-sm">Fazla
                                            Ödenen Tutar</span></div>
                                    <div>-</div>
                                    <div>-</div>
                                    <div>-</div>
                                    <div class="flex items-center gap-1">
                                        <input type="number" class="form-control w-full text-right"
                                            value="{{ $extraPayment }}" disabled />
                                        <span class="text-sm">TRY</span>
                                    </div>
                                    <div>-</div>
                                </div>
                            @endif

                        </div>


                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-success" wire:loading.attr="disabled"
                            wire:click="Save">
                            <i class="ti ti-check me-1"></i> Save
                        </button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="ti ti-x me-1"></i> Cancel
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
