<div>


    <!-- Floating Action Button -->
    <div class="floating-action-button position-{{ $config['position'] ?? 'middle-left' }}" wire:ignore.self>
        <button type="button"
            class="btn btn-primary btn-{{ $config['size'] ?? 'md' }} btn-icon rounded-circle shadow-lg customizer-style-btn"
            wire:click="toggleOffcanvas" data-bs-toggle="offcanvas" data-bs-target="#floatingActionOffcanvas"
            aria-controls="floatingActionOffcanvas" title="Quick Actions">
            <i class="ti ti-plus"></i>
        </button>
    </div>

    <!-- Offcanvas -->
    <div class="offcanvas offcanvas-end" id="floatingActionOffcanvas" tabindex="-1"
        aria-labelledby="floatingActionOffcanvasLabel" wire:ignore.self>
        <div class="offcanvas-header border-bottom">
            <h5 class="offcanvas-title" id="floatingActionOffcanvasLabel">
                <i class="ti ti-bolt me-2"></i>
                Quick Actions
            </h5>
            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>

        <div class="offcanvas-body">
            <!-- Loading Indicator -->
            @if ($isLoading)
                <div class="text-center py-4">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <p class="mt-2 text-muted">{{ __('Loading data...') }}</p>
                </div>
            @endif

            <!-- Quick Statistics -->
            @if ($config['showStats'] ?? true)
                <div class="mb-4">
                    <h6 class="mb-3">
                        <i class="ti ti-chart-bar me-2"></i>
                        Quick Stats
                    </h6>
                    <div class="row g-3">
                        @foreach ($quickStats as $stat)
                            <div class="col-6">
                                <div class="card border-0 bg-light-primary">
                                    <div class="card-body p-3">
                                        <div class="d-flex align-items-center">
                                            <div class="flex-shrink-0">
                                                <div class="avatar avatar-sm">
                                                    <span class="avatar-initial rounded bg-{{ $stat['color'] }}">
                                                        <i class="{{ $stat['icon'] }}"></i>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="flex-grow-1 ms-3">
                                                <h6 class="mb-0 fw-semibold">{{ $stat['value'] }}</h6>
                                                <small class="text-muted">{{ $stat['title'] }}</small>
                                                @if (isset($stat['change']))
                                                    <div class="mt-1">
                                                        <small
                                                            class="text-{{ $stat['changeType'] === 'positive' ? 'success' : 'danger' }}">
                                                            <i
                                                                class="ti ti-{{ $stat['changeType'] === 'positive' ? 'trending-up' : 'trending-down' }} me-1"></i>
                                                            {{ $stat['change'] }}
                                                        </small>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif

            <!-- Currency Positions -->
            @if (!empty($currencyPositions))
                <div class="mb-4">
                    <h6 class="mb-3">
                        <i class="ti ti-currency-dollar me-2"></i>
                        {{ __('Currency Positions') }}
                    </h6>
                    <div class="row g-2">
                        @foreach ($currencyPositions as $position)
                            <div class="col-6">
                                <div class="card border-0 bg-light-{{ $position['color'] }}">
                                    <div class="card-body p-2">
                                        <div class="d-flex align-items-center">
                                            <div class="flex-shrink-0">
                                                <div class="avatar avatar-sm">
                                                    <span class="avatar-initial rounded bg-{{ $position['color'] }}">
                                                        <i class="{{ $position['icon'] }}"></i>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="flex-grow-1 ms-2">
                                                <h6 class="mb-0 fw-semibold text-dark">
                                                    {{ number_format(abs($position['currency_amount']), 0) }}
                                                </h6>
                                                <small class="text-muted">
                                                    {{ $position['currency_name'] }}
                                                </small>
                                                <div class="mt-1">
                                                    <small class="text-{{ $position['color'] }} fw-bold">
                                                        ${{ number_format($position['base_amount'], 0) }}
                                                    </small>
                                                </div>
                                                @if ($position['cost'] > 0)
                                                    <div class="mt-1">
                                                        <small class="text-info fw-bold">
                                                            {{ __('Cost') }}:
                                                            {{ number_format($position['cost'], 4) }}
                                                        </small>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif

            <!-- Transfer Search Section -->
            <div class="mb-4">
                <h6 class="mb-3">
                    <i class="ti ti-search me-2"></i>
                    {{ __('Transfer Search') }}
                </h6>
                @livewire('components.transfer-search')
            </div>

            <!-- Account Search Section -->
            <div class="mb-4">
                <h6 class="mb-3">
                    <i class="ti ti-user-search me-2"></i>
                    {{ __('Account Search') }}
                </h6>
                @livewire('components.account-search')
            </div>

            <!-- Quick Actions -->
            <div class="mb-4">
                <h6 class="mb-3">
                    <i class="ti ti-zap me-2"></i>
                    Quick Actions
                </h6>
                <div class="d-grid gap-2">
                    @foreach ($actions as $action)
                        <button type="button"
                            class="btn btn-outline-{{ $action['color'] }} d-flex align-items-center justify-content-start"
                            wire:click="{{ $action['action'] }}" wire:loading.attr="disabled"
                            wire:loading.class="disabled">
                            <i class="{{ $action['icon'] }} me-2"></i>
                            {{ $action['title'] }}
                            <div wire:loading wire:target="{{ $action['action'] }}" class="ms-auto">
                                <i class="ti ti-loader ti-spin"></i>
                            </div>
                        </button>
                    @endforeach
                </div>
            </div>

            <!-- Quick Settings -->
            @if ($config['showSettings'] ?? true)
                <div class="mb-4">
                    <h6 class="mb-3">
                        <i class="ti ti-settings me-2"></i>
                        Quick Settings
                    </h6>
                    <div class="d-grid gap-3">
                        @foreach ($settings as $setting)
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="setting-{{ $setting['id'] }}"
                                    wire:model.live="settings.{{ $loop->index }}.value"
                                    wire:change="toggleSetting('{{ $setting['id'] }}')">
                                <label class="form-check-label" for="setting-{{ $setting['id'] }}">
                                    <div class="d-flex align-items-center">
                                        <i class="{{ $setting['icon'] }} me-2"></i>
                                        <div>
                                            <div class="fw-semibold">{{ $setting['title'] }}</div>
                                            <small class="text-muted">{{ $setting['description'] }}</small>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif

            <!-- Recent Activity -->
            @if ($config['showActivity'] ?? true)
                <div class="mb-4">
                    <h6 class="mb-3">
                        <i class="ti ti-clock me-2"></i>
                        Recent Activity
                    </h6>
                    <div class="list-group list-group-flush">
                        @forelse($recentActivity as $activity)
                            <div class="list-group-item px-0">
                                <div class="d-flex align-items-center">
                                    <div class="flex-shrink-0">
                                        <div class="avatar avatar-xs">
                                            <span class="avatar-initial rounded bg-{{ $activity['color'] }}">
                                                <i class="{{ $activity['icon'] }}"></i>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <p class="mb-0 small">{{ $activity['title'] }}</p>
                                        <small class="text-muted">{{ $activity['description'] }} •
                                            {{ $activity['time'] }}</small>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="text-center text-muted py-3">
                                <i class="ti ti-inbox ti-lg mb-2"></i>
                                <p class="mb-0 small">No recent activity</p>
                            </div>
                        @endforelse
                    </div>
                </div>
            @endif
        </div>
    </div>

    <!-- Custom CSS for floating button -->
    <style>
        .floating-action-button {
            position: fixed;
            z-index: 1050;
            width: 38px;
            height: 38px;
        }

        .floating-action-button.position-bottom-right {
            bottom: 2rem;
            right: 2rem;
        }

        .floating-action-button.position-bottom-left {
            bottom: 2rem;
            left: 2rem;
        }

        .floating-action-button.position-top-right {
            top: 2rem;
            right: 2rem;
        }

        .floating-action-button.position-top-left {
            top: 2rem;
            left: 2rem;
        }

        .floating-action-button.position-middle-left {
            top: 50%;
            left: 0;
            transform: translateY(-50%);
        }

        .floating-action-button.position-middle-right {
            top: 50%;
            right: 2rem;
            transform: translateY(-50%);
        }

        .floating-action-button.position-center {
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        .floating-action-button .customizer-style-btn {
            /* Copy exact styling from template customizer */
            width: 38px !important;
            height: 38px !important;
            border-top-left-radius: 0.375rem !important;
            border-bottom-left-radius: 0.375rem !important;
            background: var(--bs-primary) !important;
            box-shadow: 0px 2px 6px 0px rgba(115, 103, 240, 0.3) !important;
            color: #fff !important;
            text-align: center;
            font-size: 18px !important;
            line-height: 38px !important;
            opacity: 1;
            transition: all 0.1s linear 0.2s;
            border: none !important;
            z-index: 99999999;
            cursor: pointer;
            padding: 0 !important;
        }

        .floating-action-button .customizer-style-btn.btn-sm {
            width: 32px !important;
            height: 32px !important;
            font-size: 16px !important;
            line-height: 32px !important;
        }

        .floating-action-button .customizer-style-btn.btn-md {
            width: 38px !important;
            height: 38px !important;
            font-size: 18px !important;
            line-height: 38px !important;
        }

        .floating-action-button .customizer-style-btn.btn-lg {
            width: 44px !important;
            height: 44px !important;
            font-size: 20px !important;
            line-height: 44px !important;
        }

        .floating-action-button .customizer-style-btn:hover {
            transform: scale(1.05);
            box-shadow: 0px 4px 12px 0px rgba(115, 103, 240, 0.4) !important;
        }

        .floating-action-button .customizer-style-btn:active {
            transform: scale(0.98);
        }

        /* RTL Support - Copy from template customizer */
        [dir='rtl'] .floating-action-button .customizer-style-btn {
            border-radius: 0 !important;
            border-top-right-radius: 0.375rem !important;
            border-bottom-right-radius: 0.375rem !important;
        }

        /* Dark mode support */
        .dark-style .floating-action-button .customizer-style-btn {
            background: var(--bs-primary) !important;
        }

        /* Offcanvas customizations */
        #floatingActionOffcanvas {
            width: 400px;
        }

        @media (max-width: 576px) {
            #floatingActionOffcanvas {
                width: 100%;
            }

            .floating-action-button {
                bottom: 1rem;
                right: 1rem;
            }

            .floating-action-button.position-middle-left {
                top: 50%;
                left: 0;
                transform: translateY(-50%);
            }

            .floating-action-button.position-middle-right {
                top: 50%;
                right: 1rem;
                transform: translateY(-50%);
            }

            .floating-action-button .customizer-style-btn {
                width: 38px !important;
                height: 38px !important;
                font-size: 18px !important;
                line-height: 38px !important;
            }
        }

        /* Animation for offcanvas content */
        .offcanvas-body>div {
            animation: slideInUp 0.3s ease-out;
        }

        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Card hover effects */
        .card.bg-light-primary:hover {
            transform: translateY(-2px);
            transition: transform 0.2s ease;
        }

        /* Button hover effects */
        .btn-outline-primary:hover,
        .btn-outline-success:hover,
        .btn-outline-info:hover,
        .btn-outline-warning:hover {
            transform: translateY(-1px);
            transition: transform 0.2s ease;
        }
    </style>

    <!-- JavaScript for enhanced interactions -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            console.log('Floating Action Button Component Loaded');

            // Handle offcanvas events
            const offcanvas = document.getElementById('floatingActionOffcanvas');
            if (offcanvas) {
                offcanvas.addEventListener('show.bs.offcanvas', function() {
                    console.log('Offcanvas opened');
                    // Trigger Livewire refresh when offcanvas opens
                    @this.call('loadQuickStats');
                });
            }

            // Add ripple effect to floating button
            const floatingBtn = document.querySelector('.floating-action-button .customizer-style-btn');
            if (floatingBtn) {
                floatingBtn.addEventListener('click', function(e) {
                    console.log('Floating button clicked');
                    const ripple = document.createElement('span');
                    const rect = this.getBoundingClientRect();
                    const size = Math.max(rect.width, rect.height);
                    const x = e.clientX - rect.left - size / 2;
                    const y = e.clientY - rect.top - size / 2;

                    ripple.style.width = ripple.style.height = size + 'px';
                    ripple.style.left = x + 'px';
                    ripple.style.top = y + 'px';
                    ripple.classList.add('ripple');

                    this.appendChild(ripple);

                    setTimeout(() => {
                        ripple.remove();
                    }, 600);
                });
            }
        });

        // Listen for Livewire events
        document.addEventListener('livewire:init', () => {
            console.log('Livewire initialized for Floating Action Button');

            Livewire.on('showNotification', (event) => {
                // You can integrate with your existing notification system
                console.log('Notification:', event.message);
                // Example: show toast notification
                if (typeof toastr !== 'undefined') {
                    toastr[event.type](event.message);
                }
            });

            Livewire.on('toggleDarkMode', (event) => {
                // Handle dark mode toggle
                document.documentElement.classList.toggle('dark-style', event);
            });
        });
    </script>

    <!-- Ripple effect CSS -->
    <style>
        .btn {
            position: relative;
            overflow: hidden;
        }

        .ripple {
            position: absolute;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.6);
            transform: scale(0);
            animation: ripple-animation 0.6s linear;
            pointer-events: none;
        }

        @keyframes ripple-animation {
            to {
                transform: scale(4);
                opacity: 0;
            }
        }
    </style>
</div>
