<div wire:ignore x-data="{
    select2Instance: null,
    currentValue: @entangle('value'),
    options: @entangle('options'),
    placeholder: '{{ $placeholder }}',
    isMultiple: {{ $isMultiple ? 'true' : 'false' }},
    isSearchable: {{ $isSearchable ? 'true' : 'false' }},
    searchUrl: @entangle('searchUrl'),
    isUpdating: false,
    searchTimeout: null,

    init() {
        this.$nextTick(() => {
            this.initSelect2();
            if (this.currentValue) {
                this.safeSetSelect2Value(this.currentValue);
            }
        });

        // Watch for value changes
        this.$watch('currentValue', (value) => {
            if (!this.isUpdating && this.select2Instance && value !== undefined) {
                this.safeSetSelect2Value(value);
            }
        });

        // Watch for options changes
        this.$watch('options', (newOptions) => {
            if (this.select2Instance) {
                this.refreshOptions(newOptions);
            }
        });

        // Listen for external updates
        Livewire.on('select2ValueChanged', (value) => {
            this.currentValue = value;
        });

        Livewire.on('select2OptionsRefreshed', (options) => {
            this.options = options;
        });
    },

    initSelect2() {
        const config = {
            minimumResultsForSearch: this.isSearchable ? 0 : -1,
            dropdownParent: $(this.$refs.select).closest('.select2_content') || $('body'),
            width: '100%',
            placeholder: this.placeholder,
            allowClear: true,
            closeOnSelect: !this.isMultiple
        };

        if (this.isMultiple) {
            config.closeOnSelect = false;
        }

        this.select2Instance = $(this.$refs.select).select2(config);

        // Debounced search to prevent excessive API calls
        this.select2Instance.on('select2:open', () => {
            if (this.searchUrl) {
                clearTimeout(this.searchTimeout);
                this.searchTimeout = setTimeout(() => {
                    this.performSearch();
                }, 300);
            }
        });

        this.select2Instance.on('change', () => {
            this.isUpdating = true;
            const value = this.select2Instance.val();
            this.currentValue = value;
            @this.set('value', value, true);
            this.isUpdating = false;
        });
    },

    safeSetSelect2Value(value) {
        try {
            if (this.select2Instance) {
                this.select2Instance.val(value).trigger('change');
            }
        } catch (error) {
            console.warn('Select2 value setting error:', error);
        }
    },

    refreshOptions(newOptions) {
        try {
            if (this.select2Instance) {
                this.select2Instance.empty();
                newOptions.forEach(option => {
                    const newOption = new Option(option.text, option.id, false, false);
                    this.select2Instance.append(newOption);
                });
                this.select2Instance.trigger('change');
            }
        } catch (error) {
            console.warn('Select2 options refresh error:', error);
        }
    },

    async performSearch() {
        if (!this.searchUrl) return;

        try {
            const response = await fetch(this.searchUrl);
            const data = await response.json();
            this.options = data;
        } catch (error) {
            console.warn('Select2 search error:', error);
        }
    },

    destroy() {
        if (this.select2Instance) {
            this.select2Instance.destroy();
            this.select2Instance = null;
        }
    }
}" x-init="init()" x-on:beforeunload="destroy()">

    <select x-ref="select" class="form-select">
        <option value="">{{ $placeholder }}</option>
        @foreach ($options as $option)
            <option value="{{ $option['id'] ?? $option }}" {{ $value == ($option['id'] ?? $option) ? 'selected' : '' }}>
                {{ $option['text'] ?? $option }}
            </option>
        @endforeach
    </select>

</div>
