<div class="transfer-search-component">
    <!-- Search Form -->
    <div class="card border-0 shadow-sm">
        <div class="card-body p-3">
            <form wire:submit.prevent="searchTransfer">
                <div class="input-group">
                    <input type="text" class="form-control @error('searchReference') is-invalid @enderror"
                        placeholder="{{ __('Enter transfer reference or secret code...') }}"
                        wire:model.live.debounce.500ms="searchReference" wire:keydown.enter="searchTransfer">
                    <button class="btn btn-primary" type="submit" wire:loading.attr="disabled">
                        <i class="tf-icons ti ti-search" wire:loading.remove></i>
                        <i class="tf-icons ti ti-loader ti-spin" wire:loading></i>
                    </button>
                    @if ($searchReference)
                        <button class="btn btn-outline-secondary" type="button" wire:click="clearSearch">
                            <i class="tf-icons ti ti-x"></i>
                        </button>
                    @endif
                </div>

                @error('searchReference')
                    <div class="invalid-feedback d-block mt-2">
                        {{ $message }}
                    </div>
                @enderror
            </form>

            <!-- Error Message -->
            @if ($errorMessage)
                <div class="alert alert-danger mt-3" role="alert">
                    <i class="tf-icons ti ti-alert-circle me-2"></i>
                    {{ $errorMessage }}
                </div>
            @endif

            <!-- Search Results -->
            @if ($showResults && $transfer && is_object($transfer) && isset($transfer->id))
                <div class="mt-3">
                    <div class="alert alert-success border-success">
                        <div class="d-flex align-items-center mb-2">
                            <i class="tf-icons ti ti-check-circle me-2"></i>
                            <strong>{{ __('Transfer Found') }}</strong>
                        </div>
                        <div class="row g-2">
                            <div class="col-md-6">
                                <label class="form-label text-muted small">{{ __('Reference') }}</label>
                                <div class="fw-bold">{{ $transfer->reference ?? 'N/A' }}</div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label text-muted small">{{ __('Status') }}</label>
                                <div>
                                    @php
                                        $status = $transfer->status ?? 'unknown';
                                        $statusClass = match ($status) {
                                            'completed' => 'success',
                                            'pending' => 'warning',
                                            'cancelled' => 'danger',
                                            'blocked' => 'secondary',
                                            default => 'info',
                                        };
                                    @endphp
                                    <span class="badge bg-{{ $statusClass }}">
                                        {{ __($status) }}
                                    </span>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label text-muted small">{{ __('Amount') }}</label>
                                <div class="fw-bold text-success">
                                    {!! PriceFormat($transfer->amount ?? 0, $transfer->currency ?? 'USD') !!}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label text-muted small">{{ __('Created') }}</label>
                                <div class="fw-bold">
                                    {{ $transfer->created_at ? \Carbon\Carbon::parse($transfer->created_at)->format('d/m/Y H:i') : 'N/A' }}
                                </div>
                            </div>
                        </div>

                        <div class="mt-3">
                            <button type="button" class="btn btn-primary btn-sm"
                                wire:click="showTransferDetails({{ $transfer->id }})">
                                <i class="tf-icons ti ti-eye me-1"></i>
                                {{ __('View Full Details') }}
                            </button>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>


</div>
