<div>
    <div class="modal fade" id="transferMoneyModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-lg modal-simple">
            <div class="modal-content">
                <div class="modal-body">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <div class="text-center mb-6">
                        <h4 class="address-title mb-2">Transfer Money</h4>
                    </div>

                    <div class="row">
                        <form id="wizard-property-listing-form" wire:submit.prevent="Transfer">
                            <!-- Personal Details -->
                            <div id="personal-details" class="content active">
                                <div class="row g-6">

                                    <div class="col-md-4">
                                        <div class="mb-3 select2_content">
                                            <label class="form-label">From Account <span
                                                    class="text-danger">*</span></label>
                                            <x-Mulk.select2 wire:model="from_account_id">
                                                <option value="">Select</option>
                                                @foreach ($this->getFilteredAccounts($to_account) as $account)
                                                    <option value="{{ $account['id'] }}">
                                                        {{ $account['name'] }} ({{ $account['currency'] }})
                                                    </option>
                                                @endforeach
                                            </x-Mulk.select2>
                                            @error('from_account_id')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror

                                            <!-- From Account Balance -->
                                            @if ($from_account_id)
                                                <div class="mt-2 p-2 rounded bg-light text-primary small">
                                                    Balance:
                                                    <strong>{{ number_format($this->getAccountBalance($from_account_id), 2) }}</strong>
                                                    {{ $this->getAccountCurrency($from_account_id) }}
                                                </div>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="mb-3 select2_content">
                                            <label class="form-label">To Account <span
                                                    class="text-danger">*</span></label>
                                            <x-Mulk.select2 wire:model="to_account_id">
                                                <option value="">Select</option>
                                                @foreach ($this->getFilteredAccounts($to_account) as $account)
                                                    <option value="{{ $account['id'] }}">
                                                        {{ $account['name'] }} ({{ $account['currency'] }})
                                                    </option>
                                                @endforeach
                                            </x-Mulk.select2>
                                            @error('to_account_id')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror

                                            <!-- To Account Balance -->
                                            @if ($to_account_id)
                                                <div class="mt-2 p-2 rounded bg-light text-success small">
                                                    Balance:
                                                    <strong>{{ number_format($this->getAccountBalance($to_account_id), 2) }}</strong>
                                                    {{ $this->getAccountCurrency($to_account_id) }}
                                                </div>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="mb-3 select2_content">
                                            <label class="form-label">Amount <span class="text-danger">*</span></label>
                                            <input type="text" wire:model.live="amount" class="form-control"
                                                placeholder="0">
                                            @error('amount')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="mb-3 select2_content">
                                            <label class="form-label">Exchange Rate</label>
                                            <input type="text" wire:model="exchange_rate" class="form-control"
                                                placeholder="0" disabled>
                                            @error('exchange_rate')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="mb-3 select2_content">
                                            <label class="form-label">Calculated Amount</label>
                                            <input type="text" wire:model="calculated_amount" class="form-control"
                                                placeholder="0" disabled>
                                            @error('calculated_amount')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="mb-3">
                                            <label class="form-label">Description</label>
                                            <textarea class="form-control" wire:model="description" placeholder="Description"></textarea>
                                        </div>
                                    </div>

                                    <div class="col-12 d-flex justify-content-between">
                                        <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">
                                            <i class="ti ti-Cancel ti-xs me-sm-2 me-0"></i>
                                            <span class="align-middle d-sm-inline-block d-none">Cancel</span>
                                        </button>
                                        <button type="submit" class="btn btn-primary btn-next">
                                            <span class="align-middle d-sm-inline-block d-none me-sm-2">Save</span>
                                            <i class="ti ti-Save ti-xs"></i>
                                        </button>
                                    </div>

                                </div>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
